/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.worldguard;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldguard.bukkit.RegionContainer;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.services.worldguard.CuboidRegionProperties;
import org.kingdoms.services.worldguard.ServiceWorldGuard;

public final class ServiceWorldGuardSix
extends ServiceWorldGuard {
    @Override
    public boolean isAvailable() {
        try {
            this.getRegionContainer();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public ProtectedRegion isLocationInRegion(World world, CuboidRegionProperties properties) {
        try {
            BlockVector pos1 = BlockVector.toBlockPoint((double)properties.minX, (double)0.0, (double)properties.minZ);
            BlockVector pos2 = BlockVector.toBlockPoint((double)properties.maxX, (double)world.getMaxHeight(), (double)properties.maxZ);
            ProtectedCuboidRegion region = new ProtectedCuboidRegion("ChunkRegion", pos1, pos2);
            RegionManager manager = this.getRegionManager(world);
            ApplicableRegionSet regions = manager.getApplicableRegions((ProtectedRegion)region);
            if (regions.size() == 0) {
                return null;
            }
            return (ProtectedRegion)regions.iterator().next();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isLocationInRegion(Location location, String regionName) {
        try {
            RegionManager manager = this.getRegionManager(location.getWorld());
            if (manager == null) {
                return false;
            }
            ApplicableRegionSet regions = manager.getApplicableRegions(location);
            for (ProtectedRegion region : regions.getRegions()) {
                if (!region.getId().equals(regionName)) continue;
                return false;
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public RegionContainer getRegionContainer() {
        return WorldGuardPlugin.inst().getRegionContainer();
    }

    @Override
    public boolean isClaimable(ProtectedRegion region) {
        return false;
    }

    @Override
    protected @Nullable RegionManager getRegionManager(@NonNull World world) {
        Objects.requireNonNull(world, "Cannot get WorldGuard region manager from a null world");
        try {
            return this.getRegionContainer().get(world);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean hasFlag(Player player, Location location, StateFlag flag) {
        RegionManager manager = this.getRegionManager(location.getWorld());
        if (manager == null) {
            return false;
        }
        return manager.getApplicableRegions(location).queryValue((RegionAssociable)WorldGuardPlugin.inst().wrapPlayer(player), (Flag)flag) == StateFlag.State.ALLOW;
    }
}

