/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.blocktransformation;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.utils.blocktransformation.BlockTransformation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/utils/blocktransformation/ChangeBlockMaterial;", "Lorg/kingdoms/utils/blocktransformation/BlockTransformation;", "location", "Lorg/bukkit/Location;", "from", "Lorg/kingdoms/libs/xseries/XMaterial;", "to", "(Lorg/bukkit/Location;Lcom/cryptomorin/xseries/XMaterial;Lcom/cryptomorin/xseries/XMaterial;)V", "getFrom", "()Lcom/cryptomorin/xseries/XMaterial;", "setFrom", "(Lcom/cryptomorin/xseries/XMaterial;)V", "getTo", "setTo", "apply", "", "reverse", "", "core"})
public final class ChangeBlockMaterial
extends BlockTransformation {
    @NotNull
    private XMaterial from;
    @NotNull
    private XMaterial to;

    public ChangeBlockMaterial(@NotNull Location location, @NotNull XMaterial from, @NotNull XMaterial to) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)from), (String)"from");
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super(location);
        this.from = from;
        this.to = to;
    }

    @NotNull
    public final XMaterial getFrom() {
        return this.from;
    }

    public final void setFrom(@NotNull XMaterial xMaterial) {
        Intrinsics.checkNotNullParameter((Object)((Object)xMaterial), (String)"<set-?>");
        this.from = xMaterial;
    }

    @NotNull
    public final XMaterial getTo() {
        return this.to;
    }

    public final void setTo(@NotNull XMaterial xMaterial) {
        Intrinsics.checkNotNullParameter((Object)((Object)xMaterial), (String)"<set-?>");
        this.to = xMaterial;
    }

    @Override
    public void apply(boolean reverse) {
        Block block = this.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"location.block");
        Block block2 = block;
        XMaterial xMaterial = XMaterial.matchXMaterial(block2.getType());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)xMaterial), (String)"matchXMaterial(block.type)");
        XMaterial currentMaterial = xMaterial;
        if (reverse) {
            if (currentMaterial != this.to) {
                this.to = currentMaterial;
            }
        } else if (currentMaterial != this.from) {
            this.from = currentMaterial;
        }
        XBlock.setType(block2, reverse ? this.from : this.to);
    }
}

