/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.bossbars;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.bossbars.BossBarSettings;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\r2\b\u0010\u0002\u001a\u0004\u0018\u00010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSession;", "", "settings", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "(Lorg/kingdoms/utils/bossbars/BossBarSettings;)V", "bossBar", "Lorg/bukkit/boss/BossBar;", "players", "", "Lorg/bukkit/entity/Player;", "getPlayers", "()Ljava/util/List;", "addPlayer", "", "player", "removeAll", "removePlayer", "setColor", "color", "Lorg/bukkit/boss/BarColor;", "setProgress", "progress", "", "setVisible", "visible", "", "updateTitle", "Lorg/kingdoms/locale/provider/MessageBuilder;", "Companion", "core"})
public class BossBarSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BossBarSettings settings;
    @NotNull
    private final BossBar bossBar;

    public BossBarSession(@NotNull BossBarSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        BarFlag[] barFlagArray = this.settings.getFlags$core();
        BossBar bossBar = Bukkit.createBossBar(null, (BarColor)this.settings.getColor$core(), (BarStyle)this.settings.getStyle$core(), (BarFlag[])Arrays.copyOf(barFlagArray, barFlagArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)bossBar, (String)"createBossBar(null, sett\u2026s.style, *settings.flags)");
        this.bossBar = bossBar;
    }

    public final void setVisible(boolean visible) {
        this.bossBar.setVisible(visible);
    }

    public final void setColor(@NotNull BarColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.bossBar.setColor(color);
    }

    public final void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.bossBar.removePlayer(player);
    }

    public final void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.bossBar.addPlayer(player);
    }

    @NotNull
    public final List<Player> getPlayers() {
        List list2 = this.bossBar.getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"bossBar.players");
        return list2;
    }

    public final void removeAll() {
        this.bossBar.removeAll();
    }

    public final void setProgress(double progress) {
        this.bossBar.setProgress(progress);
    }

    public final void updateTitle(@Nullable MessageBuilder settings) {
        this.bossBar.setTitle(this.settings.getTitle$core().buildPlain(settings));
    }

    @JvmStatic
    @Nullable
    public static final BossBarSession from(@Nullable ConfigSection section) {
        return Companion.from(section);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSession$Companion;", "", "()V", "from", "Lorg/kingdoms/utils/bossbars/BossBarSession;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final BossBarSession from(@Nullable ConfigSection section) {
            return section == null ? null : new BossBarSession(BossBarSettings.Companion.fromSection(section));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

