/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.bossbars;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006$"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSettings;", "", "rawTitle", "", "color", "Lorg/bukkit/boss/BarColor;", "style", "Lorg/bukkit/boss/BarStyle;", "flags", "", "Lorg/bukkit/boss/BarFlag;", "(Ljava/lang/String;Lorg/bukkit/boss/BarColor;Lorg/bukkit/boss/BarStyle;[Lorg/bukkit/boss/BarFlag;)V", "getColor$core", "()Lorg/bukkit/boss/BarColor;", "setColor$core", "(Lorg/bukkit/boss/BarColor;)V", "getFlags$core", "()[Lorg/bukkit/boss/BarFlag;", "setFlags$core", "([Lorg/bukkit/boss/BarFlag;)V", "[Lorg/bukkit/boss/BarFlag;", "getStyle$core", "()Lorg/bukkit/boss/BarStyle;", "setStyle$core", "(Lorg/bukkit/boss/BarStyle;)V", "title", "Lorg/kingdoms/locale/compiler/MessageObject;", "getTitle$core", "()Lorg/kingdoms/locale/compiler/MessageObject;", "setTitle$core", "(Lorg/kingdoms/locale/compiler/MessageObject;)V", "toString", "", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "Companion", "core"})
public class BossBarSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String rawTitle;
    @NotNull
    private BarColor color;
    @NotNull
    private BarStyle style;
    @NotNull
    private BarFlag[] flags;
    @NotNull
    private MessageObject title;

    public BossBarSettings(@NotNull String rawTitle, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        Intrinsics.checkNotNullParameter((Object)rawTitle, (String)"rawTitle");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        this.rawTitle = rawTitle;
        this.color = color;
        this.style = style;
        this.flags = flags;
        MessageObject messageObject = MessageCompiler.compile(this.rawTitle);
        Intrinsics.checkNotNullExpressionValue((Object)messageObject, (String)"compile(this.rawTitle)");
        this.title = messageObject;
    }

    @NotNull
    public final BarColor getColor$core() {
        return this.color;
    }

    public final void setColor$core(@NotNull BarColor barColor) {
        Intrinsics.checkNotNullParameter((Object)barColor, (String)"<set-?>");
        this.color = barColor;
    }

    @NotNull
    public final BarStyle getStyle$core() {
        return this.style;
    }

    public final void setStyle$core(@NotNull BarStyle barStyle) {
        Intrinsics.checkNotNullParameter((Object)barStyle, (String)"<set-?>");
        this.style = barStyle;
    }

    @NotNull
    public final BarFlag[] getFlags$core() {
        return this.flags;
    }

    public final void setFlags$core(@NotNull BarFlag[] barFlagArray) {
        Intrinsics.checkNotNullParameter((Object)barFlagArray, (String)"<set-?>");
        this.flags = barFlagArray;
    }

    @NotNull
    public final MessageObject getTitle$core() {
        return this.title;
    }

    public final void setTitle$core(@NotNull MessageObject messageObject) {
        Intrinsics.checkNotNullParameter((Object)messageObject, (String)"<set-?>");
        this.title = messageObject;
    }

    public final void toString(@NotNull ConfigSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        section.set("title", (Object)this.rawTitle);
        section.set("color", (Object)this.color.name());
        section.set("style", (Object)this.style.name());
        section.set("flags", (Object)ArraysKt.toList((Object[])this.flags));
    }

    @JvmStatic
    @NotNull
    public static final BossBarSettings fromSection(@NotNull ConfigSection section) {
        return Companion.fromSection(section);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSettings$Companion;", "", "()V", "fromSection", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BossBarSettings fromSection(@NotNull ConfigSection section) {
            BarStyle barStyle;
            BarColor barColor;
            String colorStr;
            String title;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            String string = section.getString("title");
            if (string == null) {
                string = title = "";
            }
            if ((colorStr = section.getString("color")) == null) {
                barColor = BarColor.WHITE;
            } else {
                String string2 = colorStr.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                barColor = (BarColor)Enums.getIfPresent(BarColor.class, (String)string2).or((Object)BarColor.WHITE);
            }
            BarColor color = barColor;
            String styleStr = section.getString("style");
            if (styleStr == null) {
                barStyle = BarStyle.SOLID;
            } else {
                String string3 = styleStr.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                barStyle = (BarStyle)Enums.getIfPresent(BarStyle.class, (String)string3).or((Object)BarStyle.SOLID);
            }
            BarStyle style = barStyle;
            Object object = new String[]{"flags"};
            List<String> list2 = section.getStringList((String[])object);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"section.getStringList(\"flags\")");
            List<String> flagList = list2;
            List flags = new ArrayList(flagList.size());
            for (String flagName : flagList) {
                Intrinsics.checkNotNullExpressionValue((Object)flagName, (String)"flagName");
                String string4 = flagName.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                BarFlag flag = (BarFlag)Enums.getIfPresent(BarFlag.class, (String)string4).orNull();
                if (flag == null) continue;
                flags.add(flag);
            }
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
            Intrinsics.checkNotNullExpressionValue((Object)style, (String)"style");
            Collection $this$toTypedArray$iv = flags;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            BarFlag[] barFlagArray = thisCollection$iv.toArray(new BarFlag[0]);
            Intrinsics.checkNotNull((Object)barFlagArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            object = barFlagArray;
            return new BossBarSettings(title, color, style, (BarFlag[])Arrays.copyOf(object, ((Object)object).length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

