/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.kingdoms.libs.caffeine.cache.LoadingCache;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.utils.cache.PeekableMap;

public final class CaffeineWrapper<K, V>
implements PeekableMap<K, V> {
    private final LoadingCache<K, V> cache;

    public CaffeineWrapper(LoadingCache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public int size() {
        this.cache.cleanUp();
        return (int)this.cache.estimatedSize();
    }

    @Override
    public boolean isEmpty() {
        return this.size() != 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.getIfPresent(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.cache.put(key, value);
        return null;
    }

    @Override
    public V remove(Object key) {
        this.cache.invalidate(key);
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    @Override
    public void clear() {
        this.cache.invalidateAll();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.cache.asMap().keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.cache.asMap().values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.asMap().entrySet();
    }

    @Override
    public V peek(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    @Override
    public V getIfPresent(K key) {
        return (V)this.cache.getIfPresent(key);
    }
}

