/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.compilers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.Ref;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.time.TimeUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 52\u00020\u0001:\u00103456789:;<=>?@ABB=\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0082\bJ\b\u0010\u0013\u001a\u00020\u000fH\u0002J\t\u0010\u0014\u001a\u00020\u0000H\u0082\bJ,\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00032\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J\u0017\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001fH\u0082\bJ\u0011\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u000fH\u0082\bJ\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\t\u0010%\u001a\u00020\bH\u0082\bJ\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0005H\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\bH\u0002J\u0018\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\bH\u0002J\u0019\u00101\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0082\bJ\b\u00102\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler;", "", "expression", "", "offset", "", "end", "sub", "", "lexicalEnv", "Ljava/util/LinkedList;", "Lorg/kingdoms/utils/compilers/MathCompiler$LexicalEnvironment;", "(Ljava/lang/String;IIZLjava/util/LinkedList;)V", "syntaxTree", "build", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "charAt", "", "index", "compile", "delegate", "exception", "Ljava/lang/ArithmeticException;", "Lorg/kingdoms/libs/kotlin/ArithmeticException;", "ofs", "txt", "pointers", "", "grouped", "Lorg/kingdoms/utils/compilers/MathCompiler$BiOperation;", "iter", "", "handleOperand", "", "handleOperator", "op", "Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "isInsideFunction", "parseFunction", "Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;", "name", "parsePeriod", "Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExpr;", "beg", "parseVariable", "interpolation", "skipUntilNonVar", "firstOfs", "varInterpolation", "skipWhitespace", "untilNonDouble", "Arity", "BiOperation", "Companion", "ConstantExpr", "ConstantExprType", "Expression", "FnArgs", "Function", "FunctionExpr", "LexicalEnvironment", "Operator", "QuantumFunction", "Side", "StringConstant", "TriDoubleFn", "Variable", "core"})
public final class MathCompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String expression;
    private int offset;
    private final int end;
    private final boolean sub;
    @NotNull
    private final LinkedList<LexicalEnvironment> lexicalEnv;
    @NotNull
    private final LinkedList<Object> syntaxTree;
    @NotNull
    private static final Map<String, Double> CONSTANTS = new HashMap(8);
    @NotNull
    private static final Map<String, Function> FUNCTIONS = new HashMap(44);
    @NotNull
    private static final Operator[] OPERATORS = new Operator[127];
    @NotNull
    private static final java.util.function.Function<String, Double> EMPTY_VARS = MathCompiler::EMPTY_VARS$lambda-6;
    @JvmField
    @NotNull
    public static final Expression DEFAULT_VALUE = new ConstantExpr(0.0, ConstantExprType.NUMBER);

    private MathCompiler(String expression, int offset, int end, boolean sub, LinkedList<LexicalEnvironment> lexicalEnv) {
        this.expression = expression;
        this.offset = offset;
        this.end = end;
        this.sub = sub;
        this.lexicalEnv = lexicalEnv;
        this.syntaxTree = new LinkedList();
    }

    /* synthetic */ MathCompiler(String string, int n, int n2, boolean bl, LinkedList linkedList, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = string.length();
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        if ((n3 & 0x10) != 0) {
            linkedList = new LinkedList<LexicalEnvironment>();
        }
        this(string, n, n2, bl, linkedList);
    }

    private final int skipWhitespace(int ofs, int end) {
        int ofs2;
        boolean $i$f$skipWhitespace = false;
        for (ofs2 = ofs; ofs2 < end && this.expression.charAt(ofs2) == ' '; ++ofs2) {
        }
        return ofs2;
    }

    private final int skipUntilNonVar(int firstOfs, boolean varInterpolation) {
        int ofs = firstOfs;
        MathCompiler this_$iv = this;
        boolean $i$f$charAt = false;
        char ch = this_$iv.expression.charAt(ofs);
        if (varInterpolation) {
            while (ch != '}') {
                if (++ofs == this.end) {
                    throw MathCompiler.exception$default(this, firstOfs - 1, "Unclosed variable interpolation", null, 4, null);
                }
                this_$iv = this;
                $i$f$charAt = false;
                ch = this_$iv.expression.charAt(ofs);
            }
            ++ofs;
        } else {
            while (true) {
                if (!('a' <= ch ? ch < '{' : false)) {
                    if (!('A' <= ch ? ch < '[' : false)) {
                        boolean bl = '0' <= ch ? ch < ':' : false;
                        if (!bl && ch != '_') break;
                    }
                }
                if (++ofs == this.end) {
                    return ofs;
                }
                this_$iv = this;
                $i$f$charAt = false;
                ch = this_$iv.expression.charAt(ofs);
            }
        }
        return ofs;
    }

    private final MathCompiler delegate() {
        boolean $i$f$delegate = false;
        return new MathCompiler(this.expression, this.offset, this.end, true, this.lexicalEnv);
    }

    private final char charAt(int index) {
        boolean $i$f$charAt = false;
        return this.expression.charAt(index);
    }

    private final boolean isInsideFunction() {
        boolean $i$f$isInsideFunction = false;
        return this.lexicalEnv.stream().anyMatch(isInsideFunction.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Expression compile() throws NumberFormatException, ArithmeticException {
        if (this.offset == this.end) {
            return this.build();
        }
        do {
            block28: {
                Object last$iv;
                Expression sentence$iv;
                MathCompiler this_$iv;
                block31: {
                    Operator op;
                    char ch;
                    block29: {
                        Expression operand;
                        block30: {
                            Expression expression;
                            int from;
                            void this_$iv2;
                            MathCompiler mathCompiler = this;
                            int index$iv = this.offset;
                            boolean $i$f$charAt = false;
                            ch = this_$iv2.expression.charAt(index$iv);
                            if (ch == ' ') break block28;
                            index$iv = ch;
                            boolean bl = 48 <= index$iv ? index$iv < 58 : false;
                            if (bl) {
                                ConstantExpr constantExpr;
                                String evaluated;
                                from = this.offset;
                                this.untilNonDouble();
                                int n = this.offset;
                                this.offset = n + -1;
                                int to = n;
                                Intrinsics.checkNotNullExpressionValue((Object)this.expression.substring(from, to), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                try {
                                    constantExpr = new ConstantExpr(Double.parseDouble(evaluated), ConstantExprType.NUMBER);
                                }
                                catch (NumberFormatException thr) {
                                    throw this.exception(from, "Invalid numeric value \"" + evaluated + '\"', MathCompiler.Companion.pointerToName(from, evaluated));
                                }
                                expression = constantExpr;
                            } else {
                                boolean bl2 = (97 <= index$iv ? index$iv < 123 : false) ? true : (65 <= index$iv ? index$iv < 91 : false);
                                if (bl2) {
                                    expression = this.parseVariable(false);
                                } else if (index$iv == 123) {
                                    from = this.offset;
                                    this.offset = from + 1;
                                    expression = this.parseVariable(true);
                                } else {
                                    if (index$iv == 34) {
                                        from = this.offset;
                                        this.offset = from + 1;
                                        StringBuilder str = new StringBuilder();
                                        char chr = '\u0000';
                                        do {
                                            void this_$iv3;
                                            MathCompiler evaluated = this;
                                            int n = this.offset;
                                            this.offset = n + 1;
                                            int index$iv2 = n;
                                            boolean $i$f$charAt2 = false;
                                            chr = this_$iv3.expression.charAt(index$iv2);
                                            str.append(chr);
                                        } while (chr != '\"');
                                        String string = str.toString();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
                                        return new StringConstant(string);
                                    }
                                    if (index$iv == 44 ? true : index$iv == 59) {
                                        LexicalEnvironment lexicalEnvironment = this.lexicalEnv.peekLast();
                                        if (lexicalEnvironment == null) {
                                            throw MathCompiler.exception$default(this, this.offset, "Function argument separator outside of functions", null, 4, null);
                                        }
                                        LexicalEnvironment last = lexicalEnvironment;
                                        Object this_$iv4 = last;
                                        boolean $i$f$isFunction = false;
                                        if (((LexicalEnvironment)this_$iv4).getFunction() != null) return this.build();
                                        this_$iv4 = this;
                                        boolean $i$f$isInsideFunction = false;
                                        if (!((MathCompiler)this_$iv4).lexicalEnv.stream().anyMatch(isInsideFunction.1.INSTANCE)) throw MathCompiler.exception$default(this, this.offset, "Function argument separator outside of functions", null, 4, null);
                                        throw MathCompiler.exception$default(this, last.getIndex(), "Unclosed parentheses", null, 4, null);
                                    }
                                    if (index$iv == 91) {
                                        expression = this.parsePeriod(this.offset);
                                    } else if (index$iv == 40) {
                                        int last = this.offset;
                                        this.offset = last + 1;
                                        this.lexicalEnv.add(new LexicalEnvironment(last, null));
                                        MathCompiler this_$iv5 = this;
                                        boolean $i$f$delegate = false;
                                        MathCompiler subExpr = new MathCompiler(this_$iv5.expression, this_$iv5.offset, this_$iv5.end, true, this_$iv5.lexicalEnv);
                                        Expression compiled = subExpr.compile();
                                        this.offset = subExpr.offset;
                                        expression = compiled;
                                    } else {
                                        if (index$iv == 41) {
                                            LexicalEnvironment lexicalEnvironment = this.lexicalEnv.pollLast();
                                            if (lexicalEnvironment == null) {
                                                throw MathCompiler.exception$default(this, this.offset, "No opening parentheses found for closing parenthes", null, 4, null);
                                            }
                                            LexicalEnvironment last = lexicalEnvironment;
                                            Function function = last.getFunction();
                                            if (function != null ? function.getArgCount() == 0 : false) return this.build();
                                            if (!this.syntaxTree.isEmpty()) return this.build();
                                            throw MathCompiler.exception$default(this, this.offset, "Empty subexpression", null, 4, null);
                                        }
                                        expression = operand = null;
                                    }
                                }
                            }
                            if (operand == null) break block29;
                            this_$iv = this;
                            boolean $i$f$handleOperand = false;
                            if (!this_$iv.syntaxTree.isEmpty()) break block30;
                            this_$iv.syntaxTree.add(operand);
                            break block28;
                        }
                        sentence$iv = operand;
                        last$iv = this_$iv.syntaxTree.getLast();
                        if (!(last$iv instanceof Operator)) {
                            throw MathCompiler.exception$default(this_$iv, this_$iv.offset, "Expected an operator before operand", null, 4, null);
                        }
                        break block31;
                    }
                    Companion this_$iv6 = Companion;
                    boolean $i$f$getOperator = false;
                    Operator operator = op = OPERATORS[ch];
                    if (operator == null) throw MathCompiler.exception$default(this, this.offset, "Unrecognized character '" + ch + "' (" + ch + ") outside of variable/placeholder interpolation", null, 4, null);
                    this.handleOperator(operator);
                    break block28;
                }
                block9: while (last$iv != null && last$iv instanceof Operator) {
                    switch (WhenMappings.$EnumSwitchMapping$0[((Operator)last$iv).getArity$core().ordinal()]) {
                        case 1: {
                            break block9;
                        }
                        case 2: {
                            sentence$iv = new BiOperation(DEFAULT_VALUE, (Operator)last$iv, sentence$iv);
                            this_$iv.syntaxTree.removeLast();
                            break;
                        }
                        case 3: {
                            this_$iv.syntaxTree.removeLast();
                            Object lastLast$iv = this_$iv.syntaxTree.peekLast();
                            if (lastLast$iv == null || lastLast$iv instanceof Operator) {
                                sentence$iv = new BiOperation(DEFAULT_VALUE, (Operator)last$iv, sentence$iv);
                                break;
                            }
                            this_$iv.syntaxTree.add(last$iv);
                            break block9;
                        }
                    }
                    last$iv = this_$iv.syntaxTree.peekLast();
                }
                this_$iv.syntaxTree.addLast(sentence$iv);
            }
            int n = this.offset;
            this.offset = n + 1;
        } while (this.offset < this.end);
        return this.build();
    }

    private final Expression build() {
        if (!(this.offset < this.end && this.sub || this.lexicalEnv.isEmpty())) {
            ArrayList list2 = new ArrayList();
            Ref.BooleanRef includesFunction = new Ref.BooleanRef();
            this.lexicalEnv.stream().forEach(arg_0 -> MathCompiler.build$lambda-0(list2, includesFunction, arg_0));
            throw this.exception(this.lexicalEnv.getLast().getIndex(), "Unclosed parentheses" + (includesFunction.element ? " and functions" : ""), list2);
        }
        if (this.syntaxTree.isEmpty()) {
            return DEFAULT_VALUE;
        }
        if (this.syntaxTree.size() == 1) {
            Object object = this.syntaxTree.getLast();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
            return (Expression)object;
        }
        Object it = this.syntaxTree.getLast();
        boolean bl = false;
        if (it instanceof Operator) {
            String suggestIfPlaceholder = ((Operator)it).getSymbol() == '%' ? " (Hint: Write placeholders without % around them." : "";
            throw MathCompiler.exception$default(this, this.end - 1, "Blank operand on right hand side of " + ((Operator)it).getSymbol() + suggestIfPlaceholder, null, 4, null);
        }
        BiOperation operation = null;
        ListIterator<BiOperation> listIterator = this.syntaxTree.listIterator();
        Intrinsics.checkNotNullExpressionValue(listIterator, (String)"syntaxTree.listIterator()");
        ListIterator<BiOperation> iter = listIterator;
        while (iter.hasNext()) {
            BiOperation biOperation;
            MathCompiler this_$iv = this;
            boolean $i$f$grouped = false;
            Object e = iter.next();
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
            Expression lhs$iv = (Expression)e;
            Object e2 = iter.next();
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
            Operator op$iv = (Operator)e2;
            Object e3 = iter.next();
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
            Expression rhs$iv = (Expression)e3;
            if (!iter.hasNext()) {
                biOperation = new BiOperation(lhs$iv, op$iv, rhs$iv);
            } else {
                BiOperation operation$iv;
                Object e4 = iter.next();
                Intrinsics.checkNotNull(e4, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
                Operator op2$iv = (Operator)e4;
                Object e5 = iter.next();
                Intrinsics.checkNotNull(e5, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
                Expression op2Rhs$iv = (Expression)e5;
                if (op$iv.hasPrecedenceOver$core(op2$iv)) {
                    operation$iv = new BiOperation(lhs$iv, op$iv, rhs$iv);
                    ListIterator<BiOperation> $this$grouped_u24lambda_u2d2$iv = iter;
                    boolean bl2 = false;
                    $this$grouped_u24lambda_u2d2$iv.previous();
                    $this$grouped_u24lambda_u2d2$iv.previous();
                    $this$grouped_u24lambda_u2d2$iv.previous();
                    $this$grouped_u24lambda_u2d2$iv.remove();
                    $this$grouped_u24lambda_u2d2$iv.previous();
                    $this$grouped_u24lambda_u2d2$iv.remove();
                    $this$grouped_u24lambda_u2d2$iv.previous();
                    $this$grouped_u24lambda_u2d2$iv.set(operation$iv);
                    biOperation = operation$iv;
                } else {
                    operation$iv = new BiOperation(rhs$iv, op2$iv, op2Rhs$iv);
                    ListIterator<BiOperation> $this$grouped_u24lambda_u2d3$iv = iter;
                    boolean bl3 = false;
                    $this$grouped_u24lambda_u2d3$iv.remove();
                    $this$grouped_u24lambda_u2d3$iv.previous();
                    $this$grouped_u24lambda_u2d3$iv.remove();
                    $this$grouped_u24lambda_u2d3$iv.previous();
                    $this$grouped_u24lambda_u2d3$iv.set(operation$iv);
                    $this$grouped_u24lambda_u2d3$iv.previous();
                    $this$grouped_u24lambda_u2d3$iv.previous();
                    biOperation = operation$iv;
                }
            }
            operation = biOperation;
        }
        BiOperation biOperation = operation;
        Intrinsics.checkNotNull(biOperation);
        return biOperation;
    }

    private final BiOperation grouped(ListIterator<Object> iter) {
        BiOperation biOperation;
        boolean $i$f$grouped = false;
        Object object = iter.next();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        Expression lhs = (Expression)object;
        Object object2 = iter.next();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
        Operator op = (Operator)object2;
        Object object3 = iter.next();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        Expression rhs = (Expression)object3;
        if (!iter.hasNext()) {
            return new BiOperation(lhs, op, rhs);
        }
        Object object4 = iter.next();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Operator");
        Operator op2 = (Operator)object4;
        Object object5 = iter.next();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.MathCompiler.Expression");
        Expression op2Rhs = (Expression)object5;
        if (op.hasPrecedenceOver$core(op2)) {
            BiOperation operation = new BiOperation(lhs, op, rhs);
            ListIterator<Object> $this$grouped_u24lambda_u2d2 = iter;
            boolean bl = false;
            $this$grouped_u24lambda_u2d2.previous();
            $this$grouped_u24lambda_u2d2.previous();
            $this$grouped_u24lambda_u2d2.previous();
            $this$grouped_u24lambda_u2d2.remove();
            $this$grouped_u24lambda_u2d2.previous();
            $this$grouped_u24lambda_u2d2.remove();
            $this$grouped_u24lambda_u2d2.previous();
            $this$grouped_u24lambda_u2d2.set(operation);
            biOperation = operation;
        } else {
            BiOperation operation = new BiOperation(rhs, op2, op2Rhs);
            ListIterator<Object> $this$grouped_u24lambda_u2d3 = iter;
            boolean bl = false;
            $this$grouped_u24lambda_u2d3.remove();
            $this$grouped_u24lambda_u2d3.previous();
            $this$grouped_u24lambda_u2d3.remove();
            $this$grouped_u24lambda_u2d3.previous();
            $this$grouped_u24lambda_u2d3.set(operation);
            $this$grouped_u24lambda_u2d3.previous();
            $this$grouped_u24lambda_u2d3.previous();
            biOperation = operation;
        }
        return biOperation;
    }

    private final void handleOperator(Operator op) {
        Object last = this.syntaxTree.peekLast();
        if (!op.getArity$core().isUnary$core() && last instanceof Operator) {
            throw MathCompiler.exception$default(this, this.offset, "Blank operand on the left hand side of binary operator", null, 4, null);
        }
        this.syntaxTree.addLast(op);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handleOperand(Expression expression) {
        boolean $i$f$handleOperand = false;
        if (this.syntaxTree.isEmpty()) {
            this.syntaxTree.add(expression);
            return;
        }
        Expression sentence = expression;
        Object last = this.syntaxTree.getLast();
        if (!(last instanceof Operator)) {
            throw MathCompiler.exception$default(this, this.offset, "Expected an operator before operand", null, 4, null);
        }
        block5: while (last != null && last instanceof Operator) {
            switch (WhenMappings.$EnumSwitchMapping$0[((Operator)last).getArity$core().ordinal()]) {
                case 1: {
                    break block5;
                }
                case 2: {
                    sentence = new BiOperation(DEFAULT_VALUE, (Operator)last, sentence);
                    this.syntaxTree.removeLast();
                    break;
                }
                case 3: {
                    this.syntaxTree.removeLast();
                    Object lastLast = this.syntaxTree.peekLast();
                    if (lastLast == null || lastLast instanceof Operator) {
                        sentence = new BiOperation(DEFAULT_VALUE, (Operator)last, sentence);
                        break;
                    }
                    this.syntaxTree.add(last);
                    break block5;
                }
            }
            last = this.syntaxTree.peekLast();
        }
        this.syntaxTree.addLast(sentence);
    }

    /*
     * WARNING - void declaration
     */
    private final void untilNonDouble() {
        void this_$iv;
        MathCompiler mathCompiler = this;
        int index$iv2 = this.offset;
        boolean $i$f$charAt = false;
        char ch = this_$iv.expression.charAt(index$iv2);
        while (true) {
            boolean bl = '0' <= ch ? ch < ':' : false;
            if (!bl && ch != 'x' && ch != 'e' && ch != 'E' && ch != '-' && ch != '.') break;
            if (ch == '-') {
                void this_$iv2;
                MathCompiler index$iv2 = this;
                int index$iv3 = this.offset - 1;
                boolean $i$f$charAt2 = false;
                char previous = this_$iv2.expression.charAt(index$iv3);
                if (previous != 'e' && previous != 'E') {
                    return;
                }
            }
            ++this.offset;
            if (this.offset == this.end) {
                return;
            }
            MathCompiler previous = this;
            index$iv2 = this.offset;
            $i$f$charAt = false;
            ch = this_$iv.expression.charAt(index$iv2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Expression parseVariable(boolean interpolation) {
        MathCompiler this_$iv;
        void end$iv;
        void ofs$iv;
        int endVar = this.skipUntilNonVar(this.offset, interpolation);
        String string = this.expression.substring(this.offset, interpolation ? endVar - 1 : endVar);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String varName = string;
        if (Intrinsics.areEqual((Object)varName, (Object)"_")) {
            throw MathCompiler.exception$default(this, this.offset, "Reserved single underscore identifier", null, 4, null);
        }
        this.offset = endVar;
        MathCompiler mathCompiler = this;
        int n = this.offset;
        int n2 = this.end;
        MathCompiler mathCompiler2 = this;
        boolean $i$f$skipWhitespace = false;
        for (ofs$iv = ofs$iv; ofs$iv < end$iv && this_$iv.expression.charAt((int)ofs$iv) == ' '; ++ofs$iv) {
        }
        void var10_11 = ofs$iv;
        mathCompiler2.offset = var10_11;
        if (this.offset < this.end) {
            this_$iv = this;
            int index$iv = this.offset;
            boolean $i$f$charAt = false;
            if (this_$iv.expression.charAt(index$iv) == '(') {
                return this.parseFunction(varName);
            }
        }
        this.offset = endVar - 1;
        Double it = CONSTANTS.get(varName);
        boolean bl = false;
        return it == null ? (Expression)new Variable(varName) : (Expression)new ConstantExpr(it, ConstantExprType.CONSTANT_VARIABLE);
    }

    private final FunctionExpr parseFunction(String name) {
        String suggestion = MathCompiler.Companion.findFunction(name);
        suggestion = suggestion == null ? "" : "; Did you mean '" + suggestion + "' function?";
        Function function = FUNCTIONS.get(name);
        if (function == null) {
            throw MathCompiler.exception$default(this, this.offset, "Unknown function: " + name + suggestion, null, 4, null);
        }
        Function fn = function;
        int n = this.offset;
        this.offset = n + 1;
        ArrayList<Expression> args = new ArrayList<Expression>();
        LexicalEnvironment instance = new LexicalEnvironment(this.offset, fn);
        this.lexicalEnv.add(instance);
        int beg = this.offset;
        do {
            MathCompiler this_$iv = this;
            boolean $i$f$delegate = false;
            MathCompiler compiler = new MathCompiler(this_$iv.expression, this_$iv.offset, this_$iv.end, true, this_$iv.lexicalEnv);
            Expression obj = compiler.compile();
            if (!Intrinsics.areEqual((Object)obj, (Object)DEFAULT_VALUE)) {
                args.add(obj);
            }
            this.offset = compiler.offset + 1;
        } while (Intrinsics.areEqual((Object)this.lexicalEnv.peekLast(), (Object)instance));
        int compiler = this.offset;
        this.offset = compiler + -1;
        if (args.size() < fn.getArgCount()) {
            throw this.exception(beg, "Too few arguments for function '" + name + "', expected: " + fn.getArgCount() + ", got: " + args.size(), MathCompiler.Companion.pointerToName(beg, name));
        }
        if (args.size() > fn.getArgCount()) {
            throw this.exception(beg, "Too many arguments for function '" + name + "', expected: " + fn.getArgCount() + ", got: " + args.size(), MathCompiler.Companion.pointerToName(beg, name));
        }
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Expression[] expressionArray = thisCollection$iv.toArray(new Expression[0]);
        Intrinsics.checkNotNull((Object)expressionArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return new FunctionExpr(name, fn, expressionArray);
    }

    private final ConstantExpr parsePeriod(int beg) {
        int timeEnd = StringsKt.indexOf$default((CharSequence)this.expression, (char)']', (int)(beg + 1), (boolean)false, (int)4, null);
        if (timeEnd == -1) {
            throw MathCompiler.exception$default(this, beg, "Cannot find time literal closing bracket.", null, 4, null);
        }
        int beg2 = beg + 1;
        String string = this.expression.substring(beg2, timeEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String timeStr = string;
        this.offset = timeEnd;
        return new ConstantExpr(TimeUtils.parseTime(timeStr).longValue(), ConstantExprType.TIME);
    }

    private final ArithmeticException exception(int ofs, String txt, Collection<Integer> pointers) {
        String errMsg = '\n' + txt + " at offset " + ofs + " in expression: \n\"" + this.expression + '\"';
        int max = 0;
        pointers.add(ofs);
        Iterator<Integer> iterator = pointers.iterator();
        while (iterator.hasNext()) {
            int pointer = ((Number)iterator.next()).intValue();
            if (pointer <= max) continue;
            max = pointer;
        }
        Companion pointer = Companion;
        int times$iv = max + 2;
        boolean $i$f$spaces = false;
        char[] spaces$iv = new char[times$iv];
        Arrays.fill(spaces$iv, ' ');
        StringBuilder pointerStr = new StringBuilder(new String(spaces$iv));
        pointers.forEach(arg_0 -> MathCompiler.exception$lambda-5(pointerStr, arg_0));
        return new ArithmeticException(errMsg + '\n' + pointerStr);
    }

    static /* synthetic */ ArithmeticException exception$default(MathCompiler mathCompiler, int n, String string, Collection collection, int n2, Object object) {
        if ((n2 & 4) != 0) {
            collection = new ArrayList();
        }
        return mathCompiler.exception(n, string, collection);
    }

    private static final void build$lambda-0(ArrayList $list, Ref.BooleanRef $includesFunction, LexicalEnvironment x) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        Intrinsics.checkNotNullParameter((Object)$includesFunction, (String)"$includesFunction");
        $list.add(x.getIndex());
        if (!$includesFunction.element) {
            LexicalEnvironment this_$iv = x;
            boolean $i$f$isFunction = false;
            $includesFunction.element = this_$iv.getFunction() != null;
        }
    }

    private static final void exception$lambda-5(StringBuilder $pointerStr, int x) {
        Intrinsics.checkNotNullParameter((Object)$pointerStr, (String)"$pointerStr");
        $pointerStr.setCharAt(x + 1, '^');
    }

    private static final Double EMPTY_VARS$lambda-6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        throw new IllegalAccessError();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Double> getConstants() {
        return Companion.getConstants();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, Function> getFunctions() {
        return Companion.getFunctions();
    }

    @JvmStatic
    @NotNull
    public static final Expression compile(@Nullable String expression) throws NumberFormatException, ArithmeticException {
        return Companion.compile(expression);
    }

    static {
        MathCompiler.Companion.registerOperators();
        MathCompiler.Companion.registerFunctions();
        MathCompiler.Companion.registerConstants();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "", "function", "Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "optimizable", "", "argCount", "", "(Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;ZI)V", "getArgCount", "()I", "getFunction$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "getOptimizable$core", "()Z", "core"})
    public static final class Function {
        @NotNull
        private final QuantumFunction function;
        private final boolean optimizable;
        private final int argCount;

        public Function(@NotNull QuantumFunction function, boolean optimizable, int argCount) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.function = function;
            this.optimizable = optimizable;
            this.argCount = argCount;
        }

        @NotNull
        public final QuantumFunction getFunction$core() {
            return this.function;
        }

        public final boolean getOptimizable$core() {
            return this.optimizable;
        }

        public final int getArgCount() {
            return this.argCount;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\fH\u0086\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$LexicalEnvironment;", "", "index", "", "function", "Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "(ILorg/kingdoms/utils/compilers/MathCompiler$Function;)V", "getFunction", "()Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "getIndex", "()I", "isFunction", "", "toString", "", "core"})
    public static final class LexicalEnvironment {
        private final int index;
        @Nullable
        private final Function function;

        public LexicalEnvironment(int index, @Nullable Function function) {
            this.index = index;
            this.function = function;
        }

        public final int getIndex() {
            return this.index;
        }

        @Nullable
        public final Function getFunction() {
            return this.function;
        }

        public final boolean isFunction() {
            boolean $i$f$isFunction = false;
            return this.getFunction() != null;
        }

        @NotNull
        public String toString() {
            LexicalEnvironment this_$iv = this;
            boolean $i$f$isFunction = false;
            return "LexicalEnvironment{index=" + this.index + ", function=" + (this_$iv.getFunction() != null) + '}';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Side;", "", "(Ljava/lang/String;I)V", "RIGHT", "LEFT", "NONE", "core"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side RIGHT = new Side();
        public static final /* enum */ Side LEFT = new Side();
        public static final /* enum */ Side NONE = new Side();
        private static final /* synthetic */ Side[] $VALUES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value) {
            return Enum.valueOf(Side.class, value);
        }

        static {
            $VALUES = sideArray = new Side[]{Side.RIGHT, Side.LEFT, Side.NONE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Arity;", "", "(Ljava/lang/String;I)V", "isUnary", "", "isUnary$core", "UNARY", "BINARY", "UNARY_AND_BINARY", "core"})
    public static final class Arity
    extends Enum<Arity> {
        public static final /* enum */ Arity UNARY = new Arity();
        public static final /* enum */ Arity BINARY = new Arity();
        public static final /* enum */ Arity UNARY_AND_BINARY = new Arity();
        private static final /* synthetic */ Arity[] $VALUES;

        public final boolean isUnary$core() {
            return this == UNARY || this == UNARY_AND_BINARY;
        }

        public static Arity[] values() {
            return (Arity[])$VALUES.clone();
        }

        public static Arity valueOf(String value) {
            return Enum.valueOf(Arity.class, value);
        }

        static {
            $VALUES = arityArray = new Arity[]{Arity.UNARY, Arity.BINARY, Arity.UNARY_AND_BINARY};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "", "apply", "", "params", "Lorg/kingdoms/utils/compilers/MathCompiler$FnArgs;", "core"})
    public static interface QuantumFunction {
        public double apply(@NotNull FnArgs var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;", "", "apply", "", "a", "b", "core"})
    public static interface TriDoubleFn {
        public double apply(double var1, double var3);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB/\b\u0000\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006 "}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "", "sym", "", "precedence", "", "function", "Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;", "(CILorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;)V", "symbol", "precedenceL", "precedenceR", "side", "Lorg/kingdoms/utils/compilers/MathCompiler$Side;", "(CIILorg/kingdoms/utils/compilers/MathCompiler$Side;Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;)V", "arity", "Lorg/kingdoms/utils/compilers/MathCompiler$Arity;", "getArity$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Arity;", "getFunction$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$TriDoubleFn;", "precedenceLeft", "", "precedenceRight", "getSymbol", "()C", "hasPrecedenceOver", "", "op", "hasPrecedenceOver$core", "toString", "", "core"})
    public static final class Operator {
        private final char symbol;
        private final byte precedenceLeft;
        private final byte precedenceRight;
        @NotNull
        private final Side side;
        @NotNull
        private final Arity arity;
        @NotNull
        private final TriDoubleFn function;

        public Operator(char symbol, int precedenceL, int precedenceR, @NotNull Side side, @NotNull TriDoubleFn function) {
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this.symbol = symbol;
            this.precedenceLeft = (byte)precedenceL;
            this.precedenceRight = (byte)precedenceR;
            this.side = side;
            this.function = function;
            char c = this.symbol;
            this.arity = c == '-' ? Arity.UNARY_AND_BINARY : (c == '~' ? Arity.UNARY : Arity.BINARY);
        }

        public final char getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final Arity getArity$core() {
            return this.arity;
        }

        @NotNull
        public final TriDoubleFn getFunction$core() {
            return this.function;
        }

        public Operator(char sym, int precedence, @NotNull TriDoubleFn function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            this(sym, precedence, precedence, Side.NONE, function);
        }

        @NotNull
        public String toString() {
            return "MathOperator['" + this.symbol + "']";
        }

        public final boolean hasPrecedenceOver$core(@NotNull Operator op) {
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            return this.precedenceLeft >= op.precedenceLeft;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00002\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tJ\"\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rj\u0002`\u000fH&J\u0006\u0010\u0010\u001a\u00020\u0004J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0000\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "", "()V", "contains", "", "T", "ofType", "Ljava/lang/Class;", "predicate", "Ljava/util/function/Predicate;", "eval", "", "variables", "Ljava/util/function/Function;", "", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "isDefault", "nullIfDefault", "core"})
    public static abstract class Expression {
        public abstract double eval(@NotNull java.util.function.Function<String, Double> var1);

        public final boolean isDefault() {
            return this == DEFAULT_VALUE;
        }

        @Nullable
        public final Expression nullIfDefault() {
            return this.isDefault() ? null : this;
        }

        public final <T extends Expression> boolean contains(@NotNull Class<T> ofType, @NotNull Predicate<T> predicate) {
            boolean bl;
            block7: {
                Expression expression;
                Intrinsics.checkNotNullParameter(ofType, (String)"ofType");
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                if (ofType.isInstance(this)) {
                    Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type T of org.kingdoms.utils.compilers.MathCompiler.Expression.contains");
                    if (predicate.test(this)) {
                        return true;
                    }
                }
                if ((expression = this) instanceof BiOperation) {
                    bl = ((BiOperation)this).getLeft$core().contains(ofType, predicate) || ((BiOperation)this).getRight$core().contains(ofType, predicate);
                } else if (expression instanceof FunctionExpr) {
                    Expression[] $this$any$iv = ((FunctionExpr)this).getArgs$core();
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Expression element$iv;
                        Expression x = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!x.contains(ofType, predicate)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\b0\nj\u0002`\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$StringConstant;", "Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExpr;", "string", "", "(Ljava/lang/String;)V", "getString$core", "()Ljava/lang/String;", "eval", "", "variables", "Ljava/util/function/Function;", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "toString", "core"})
    public static final class StringConstant
    extends ConstantExpr {
        @NotNull
        private final String string;

        public StringConstant(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            super(string.hashCode(), ConstantExprType.STRING);
            this.string = string;
        }

        @NotNull
        public final String getString$core() {
            return this.string;
        }

        @Override
        public double eval(@NotNull java.util.function.Function<String, Double> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            return super.getValue();
        }

        @Override
        @NotNull
        public String toString() {
            return '\"' + this.string + '\"';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006J\"\u0010\f\u001a\u00020\r2\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000fj\u0002`\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$BiOperation;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "left", "op", "Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "right", "(Lorg/kingdoms/utils/compilers/MathCompiler$Expression;Lorg/kingdoms/utils/compilers/MathCompiler$Operator;Lorg/kingdoms/utils/compilers/MathCompiler$Expression;)V", "getLeft$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "getOp$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "getRight$core", "eval", "", "variables", "Ljava/util/function/Function;", "", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "toString", "core"})
    public static final class BiOperation
    extends Expression {
        @NotNull
        private final Expression left;
        @NotNull
        private final Operator op;
        @NotNull
        private final Expression right;

        public BiOperation(@NotNull Expression left, @NotNull Operator op, @NotNull Expression right) {
            Intrinsics.checkNotNullParameter((Object)left, (String)"left");
            Intrinsics.checkNotNullParameter((Object)op, (String)"op");
            Intrinsics.checkNotNullParameter((Object)right, (String)"right");
            this.left = left;
            this.op = op;
            this.right = right;
        }

        @NotNull
        public final Expression getLeft$core() {
            return this.left;
        }

        @NotNull
        public final Operator getOp$core() {
            return this.op;
        }

        @NotNull
        public final Expression getRight$core() {
            return this.right;
        }

        @Override
        public double eval(@NotNull java.util.function.Function<String, Double> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            return this.op.getFunction$core().apply(this.left.eval(variables), this.right.eval(variables));
        }

        @NotNull
        public String toString() {
            return "" + '(' + this.left + ' ' + this.op.getSymbol() + (this.op.getSymbol() == '(' ? "" : Character.valueOf(' ')) + this.right + ')';
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0013j\u0002`\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "name", "", "handler", "Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "args", "", "(Ljava/lang/String;Lorg/kingdoms/utils/compilers/MathCompiler$Function;[Lorg/kingdoms/utils/compilers/MathCompiler$Expression;)V", "getArgs$core", "()[Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "[Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "getHandler$core", "()Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "getName$core", "()Ljava/lang/String;", "eval", "", "variables", "Ljava/util/function/Function;", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "toString", "core"})
    public static final class FunctionExpr
    extends Expression {
        @NotNull
        private final String name;
        @NotNull
        private final Function handler;
        @NotNull
        private final Expression[] args;

        public FunctionExpr(@NotNull String name, @NotNull Function handler, @NotNull Expression[] args) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            this.name = name;
            this.handler = handler;
            this.args = args;
        }

        @NotNull
        public final String getName$core() {
            return this.name;
        }

        @NotNull
        public final Function getHandler$core() {
            return this.handler;
        }

        @NotNull
        public final Expression[] getArgs$core() {
            return this.args;
        }

        @Override
        public double eval(@NotNull java.util.function.Function<String, Double> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            return this.handler.getFunction$core().apply(new FnArgs(this, variables));
        }

        @NotNull
        public String toString() {
            A[] AArray = Arrays.stream(this.args).map(FunctionExpr::toString$lambda-0).toArray(FunctionExpr::toString$lambda-1);
            Intrinsics.checkNotNullExpressionValue(AArray, (String)"stream(args).map { obj: \u2026ayOfNulls<String>(size) }");
            Object[] argsStr = (String[])AArray;
            return this.name + '(' + (this.args.length == 0 ? "" : ArraysKt.joinToString$default((Object[])argsStr, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)) + ')';
        }

        private static final String toString$lambda-0(Expression obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            return obj.toString();
        }

        private static final String[] toString$lambda-1(int size) {
            return new String[size];
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;", "", "(Ljava/lang/String;I)V", "OPTIMIZED", "NUMBER", "STRING", "CONSTANT_VARIABLE", "TIME", "core"})
    public static final class ConstantExprType
    extends Enum<ConstantExprType> {
        public static final /* enum */ ConstantExprType OPTIMIZED = new ConstantExprType();
        public static final /* enum */ ConstantExprType NUMBER = new ConstantExprType();
        public static final /* enum */ ConstantExprType STRING = new ConstantExprType();
        public static final /* enum */ ConstantExprType CONSTANT_VARIABLE = new ConstantExprType();
        public static final /* enum */ ConstantExprType TIME = new ConstantExprType();
        private static final /* synthetic */ ConstantExprType[] $VALUES;

        public static ConstantExprType[] values() {
            return (ConstantExprType[])$VALUES.clone();
        }

        public static ConstantExprType valueOf(String value) {
            return Enum.valueOf(ConstantExprType.class, value);
        }

        static {
            $VALUES = constantExprTypeArray = new ConstantExprType[]{ConstantExprType.OPTIMIZED, ConstantExprType.NUMBER, ConstantExprType.STRING, ConstantExprType.CONSTANT_VARIABLE, ConstantExprType.TIME};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\u00032\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00030\rj\u0002`\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExpr;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "value", "", "type", "Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;", "(DLorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;)V", "getType", "()Lorg/kingdoms/utils/compilers/MathCompiler$ConstantExprType;", "getValue", "()D", "eval", "variables", "Ljava/util/function/Function;", "", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "toString", "core"})
    public static class ConstantExpr
    extends Expression {
        private final double value;
        @NotNull
        private final ConstantExprType type;

        public ConstantExpr(double value, @NotNull ConstantExprType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.value = value;
            this.type = type;
        }

        public final double getValue() {
            return this.value;
        }

        @NotNull
        public final ConstantExprType getType() {
            return this.type;
        }

        @Override
        public double eval(@NotNull java.util.function.Function<String, Double> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            return this.value;
        }

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\bj\u0002`\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Variable;", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "name", "", "(Ljava/lang/String;)V", "eval", "", "variables", "Ljava/util/function/Function;", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "toString", "core"})
    private static final class Variable
    extends Expression {
        @NotNull
        private final String name;

        public Variable(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        @Override
        public double eval(@NotNull java.util.function.Function<String, Double> variables) {
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            Double value = variables.apply(this.name);
            if (value == null) {
                String guessFn = Companion.findFunction(this.name);
                String suggestion = "";
                if (guessFn != null) {
                    suggestion = "; Did you mean to invoke '" + guessFn + "' function? If so, put parentheses after the name like '" + guessFn + "(args)'";
                }
                throw new RuntimeException("Unknown variable: '" + this.name + '\'' + suggestion);
            }
            return value;
        }

        @NotNull
        public String toString() {
            return '{' + this.name + '}';
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0007H\u0086\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$FnArgs;", "", "func", "Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;", "variables", "Ljava/util/function/Function;", "", "", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "(Lorg/kingdoms/utils/compilers/MathCompiler$FunctionExpr;Ljava/util/function/Function;)V", "index", "", "next", "i", "core"})
    public static final class FnArgs {
        @NotNull
        private final FunctionExpr func;
        @NotNull
        private final java.util.function.Function<String, Double> variables;
        private int index;

        public FnArgs(@NotNull FunctionExpr func, @NotNull java.util.function.Function<String, Double> variables) {
            Intrinsics.checkNotNullParameter((Object)func, (String)"func");
            Intrinsics.checkNotNullParameter(variables, (String)"variables");
            this.func = func;
            this.variables = variables;
        }

        public final double next() {
            int n = this.index;
            this.index = n + 1;
            return this.func.getArgs$core()[n].eval(this.variables);
        }

        /*
         * WARNING - void declaration
         */
        public final double next(int i) {
            void it;
            int n;
            int n2 = n = i;
            Expression[] expressionArray = this.func.getArgs$core();
            boolean bl = false;
            this.index = it;
            return expressionArray[n].eval(this.variables);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0007J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u0004H\u0007J\u0013\u0010 \u001a\u0004\u0018\u00010\u00102\u0006\u0010!\u001a\u00020\"H\u0082\bJ\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0010H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001d0'2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J\b\u0010)\u001a\u00020\u0017H\u0002J\b\u0010*\u001a\u00020\u0017H\u0002J\b\u0010+\u001a\u00020\u0017H\u0002J\u0011\u0010,\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u001dH\u0082\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006."}, d2={"Lorg/kingdoms/utils/compilers/MathCompiler$Companion;", "", "()V", "CONSTANTS", "", "", "", "DEFAULT_VALUE", "Lorg/kingdoms/utils/compilers/MathCompiler$Expression;", "EMPTY_VARS", "Ljava/util/function/Function;", "Lorg/kingdoms/utils/compilers/VariableTranslator;", "FUNCTIONS", "Lorg/kingdoms/utils/compilers/MathCompiler$Function;", "OPERATORS", "", "Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "[Lorg/kingdoms/utils/compilers/MathCompiler$Operator;", "compile", "expression", "findFunction", "name", "fn", "", "optimizable", "", "handler", "Lorg/kingdoms/utils/compilers/MathCompiler$QuantumFunction;", "argCount", "", "getConstants", "getFunctions", "getOperator", "chr", "", "op", "opr", "optimize", "pointerToName", "", "from", "registerConstants", "registerFunctions", "registerOperators", "spaces", "times", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Map<String, Double> getConstants() {
            return CONSTANTS;
        }

        @JvmStatic
        @NotNull
        public final Map<String, Function> getFunctions() {
            return FUNCTIONS;
        }

        private final void op(Operator opr) {
            if (!(opr.getSymbol() < OPERATORS.length)) {
                boolean bl = false;
                String string = "Operator handler cannot handle char '" + opr.getSymbol() + "' with char code: " + opr.getSymbol();
                throw new IllegalArgumentException(string.toString());
            }
            OPERATORS[opr.getSymbol()] = opr;
        }

        private final void registerConstants() {
            CONSTANTS.put("E", Math.E);
            CONSTANTS.put("PI", Math.PI);
            CONSTANTS.put("Euler", 0.5772156649015329);
            CONSTANTS.put("LN2", 0.693147180559945);
            CONSTANTS.put("LN10", 2.302585092994046);
            CONSTANTS.put("LOG2E", 1.442695040888963);
            CONSTANTS.put("LOG10E", 0.434294481903252);
            CONSTANTS.put("PHI", 1.618033988749895);
        }

        private final void registerOperators() {
            this.op(new Operator('^', 12, 13, Side.NONE, Companion::registerOperators$lambda-1));
            this.op(new Operator('*', 10, Companion::registerOperators$lambda-2));
            this.op(new Operator('(', 10, Companion::registerOperators$lambda-3));
            this.op(new Operator('/', 10, Companion::registerOperators$lambda-4));
            this.op(new Operator('%', 10, Companion::registerOperators$lambda-5));
            this.op(new Operator('+', 9, Companion::registerOperators$lambda-6));
            this.op(new Operator('-', 9, Companion::registerOperators$lambda-7));
            this.op(new Operator('~', 10, Companion::registerOperators$lambda-8));
            this.op(new Operator('@', 8, Companion::registerOperators$lambda-9));
            this.op(new Operator('#', 8, Companion::registerOperators$lambda-10));
            this.op(new Operator('>', 8, Companion::registerOperators$lambda-11));
            this.op(new Operator('<', 8, Companion::registerOperators$lambda-12));
            this.op(new Operator('$', 8, Companion::registerOperators$lambda-13));
            this.op(new Operator('&', 7, Companion::registerOperators$lambda-14));
            this.op(new Operator('!', 6, Companion::registerOperators$lambda-15));
            this.op(new Operator('|', 5, Companion::registerOperators$lambda-16));
        }

        private final void registerFunctions() {
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "abs", Companion::registerFunctions$lambda-17, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "acos", Companion::registerFunctions$lambda-18, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "asin", Companion::registerFunctions$lambda-19, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "atan", Companion::registerFunctions$lambda-20, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "cbrt", Companion::registerFunctions$lambda-21, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "ceil", Companion::registerFunctions$lambda-22, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "cos", Companion::registerFunctions$lambda-23, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "cosh", Companion::registerFunctions$lambda-24, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "exp", Companion::registerFunctions$lambda-25, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "expm1", Companion::registerFunctions$lambda-26, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "floor", Companion::registerFunctions$lambda-27, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "getExponent", Companion::registerFunctions$lambda-28, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "log", Companion::registerFunctions$lambda-29, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "log10", Companion::registerFunctions$lambda-30, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "log1p", Companion::registerFunctions$lambda-31, 0, 4, null);
            this.fn("max", Companion::registerFunctions$lambda-32, 2);
            this.fn("min", Companion::registerFunctions$lambda-33, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "nextUp", Companion::registerFunctions$lambda-34, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "nextDown", Companion::registerFunctions$lambda-35, 0, 4, null);
            this.fn("nextAfter", Companion::registerFunctions$lambda-36, 2);
            this.fn("random", false, Companion::registerFunctions$lambda-37, 2);
            this.fn("randInt", false, Companion::registerFunctions$lambda-38, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "round", Companion::registerFunctions$lambda-39, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "rint", Companion::registerFunctions$lambda-40, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "signum", Companion::registerFunctions$lambda-41, 0, 4, null);
            this.fn("whatPercentOf", Companion::registerFunctions$lambda-42, 2);
            this.fn("percentOf", Companion::registerFunctions$lambda-43, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "sin", Companion::registerFunctions$lambda-44, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "sinh", Companion::registerFunctions$lambda-45, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "bits", Companion::registerFunctions$lambda-46, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "hash", Companion::registerFunctions$lambda-47, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "identityHash", Companion::registerFunctions$lambda-48, 0, 4, null);
            this.fn("time", false, Companion::registerFunctions$lambda-49, 0);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "sqrt", Companion::registerFunctions$lambda-50, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "tan", Companion::registerFunctions$lambda-51, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "tanh", Companion::registerFunctions$lambda-52, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "toDegrees", Companion::registerFunctions$lambda-53, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "toRadians", Companion::registerFunctions$lambda-54, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "ulp", Companion::registerFunctions$lambda-55, 0, 4, null);
            this.fn("scalb", Companion::registerFunctions$lambda-56, 2);
            this.fn("hypot", Companion::registerFunctions$lambda-57, 2);
            this.fn("copySign", Companion::registerFunctions$lambda-58, 2);
            this.fn("IEEEremainder", Companion::registerFunctions$lambda-59, 2);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "naturalSum", Companion::registerFunctions$lambda-60, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "reverse", Companion::registerFunctions$lambda-61, 0, 4, null);
            org.kingdoms.utils.compilers.MathCompiler$Companion.fn$default(this, "reverseBytes", Companion::registerFunctions$lambda-62, 0, 4, null);
            this.fn("eq", Companion::registerFunctions$lambda-63, 4);
            this.fn("ne  ", Companion::registerFunctions$lambda-64, 4);
            this.fn("gt", Companion::registerFunctions$lambda-65, 4);
            this.fn("lt", Companion::registerFunctions$lambda-66, 4);
            this.fn("ge", Companion::registerFunctions$lambda-67, 4);
            this.fn("le", Companion::registerFunctions$lambda-68, 4);
        }

        private final void fn(String name, QuantumFunction handler, int argCount) {
            this.fn(name, true, handler, argCount);
        }

        static /* synthetic */ void fn$default(Companion companion, String string, QuantumFunction quantumFunction, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1;
            }
            companion.fn(string, quantumFunction, n);
        }

        private final void fn(String name, boolean optimizable, QuantumFunction handler, int argCount) {
            FUNCTIONS.put(name, new Function(handler, optimizable, argCount));
        }

        static /* synthetic */ void fn$default(Companion companion, String string, boolean bl, QuantumFunction quantumFunction, int n, int n2, Object object) {
            if ((n2 & 8) != 0) {
                n = 1;
            }
            companion.fn(string, bl, quantumFunction, n);
        }

        @JvmStatic
        @NotNull
        public final Expression compile(@Nullable String expression) throws NumberFormatException, ArithmeticException {
            CharSequence charSequence = expression;
            if (charSequence == null || charSequence.length() == 0) {
                return DEFAULT_VALUE;
            }
            return this.optimize(new MathCompiler(expression, 0, 0, false, null, 30, null).compile());
        }

        private final Expression optimize(Expression expression) {
            Expression expression2 = expression;
            if (expression2 instanceof BiOperation) {
                Expression lhs = this.optimize(((BiOperation)expression).getLeft$core());
                Expression rhs = this.optimize(((BiOperation)expression).getRight$core());
                if (lhs instanceof ConstantExpr && rhs instanceof ConstantExpr) {
                    return new ConstantExpr(((BiOperation)expression).getOp$core().getFunction$core().apply(((ConstantExpr)lhs).getValue(), ((ConstantExpr)rhs).getValue()), ConstantExprType.OPTIMIZED);
                }
            } else if (expression2 instanceof FunctionExpr) {
                Expression expression3;
                if (!((FunctionExpr)expression).getHandler$core().getOptimizable$core()) {
                    return expression;
                }
                boolean allOptimized = true;
                ArrayList<Expression> newParameters = new ArrayList<Expression>(((FunctionExpr)expression).getArgs$core().length);
                for (Expression arg : ((FunctionExpr)expression).getArgs$core()) {
                    Expression optimized = this.optimize(arg);
                    newParameters.add(optimized);
                    if (!allOptimized) continue;
                    allOptimized = optimized instanceof ConstantExpr;
                }
                if (allOptimized) {
                    expression3 = new ConstantExpr(((FunctionExpr)expression).getHandler$core().getFunction$core().apply(new FnArgs((FunctionExpr)expression, EMPTY_VARS)), ConstantExprType.OPTIMIZED);
                } else {
                    String string = ((FunctionExpr)expression).getName$core();
                    Function function = ((FunctionExpr)expression).getHandler$core();
                    Collection $this$toTypedArray$iv = newParameters;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Expression[] expressionArray = thisCollection$iv.toArray(new Expression[0]);
                    Intrinsics.checkNotNull((Object)expressionArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    expression3 = new FunctionExpr(string, function, expressionArray);
                }
                return expression3;
            }
            return expression;
        }

        private final Operator getOperator(char chr) {
            boolean $i$f$getOperator = false;
            return OPERATORS[chr];
        }

        private final Collection<Integer> pointerToName(int from, String name) {
            List pointers = new ArrayList(name.length());
            int n = name.length();
            for (int i = 1; i < n; ++i) {
                pointers.add(from + i);
            }
            return pointers;
        }

        private final String spaces(int times) {
            boolean $i$f$spaces = false;
            char[] spaces = new char[times];
            Arrays.fill(spaces, ' ');
            return new String(spaces);
        }

        private final String findFunction(String name) {
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String lowerCaseName = string;
            Optional<String> exact = FUNCTIONS.keySet().stream().filter(arg_0 -> Companion.findFunction$lambda-69(lowerCaseName, arg_0)).findFirst();
            return exact.orElseGet(() -> Companion.findFunction$lambda-71(lowerCaseName));
        }

        private static final double registerOperators$lambda-1(double a, double b) {
            return Math.pow(a, b);
        }

        private static final double registerOperators$lambda-2(double a, double b) {
            return a * b;
        }

        private static final double registerOperators$lambda-3(double a, double b) {
            return a * b;
        }

        private static final double registerOperators$lambda-4(double a, double b) {
            return a / b;
        }

        private static final double registerOperators$lambda-5(double a, double b) {
            return a % b;
        }

        private static final double registerOperators$lambda-6(double a, double b) {
            return Double.sum(a, b);
        }

        private static final double registerOperators$lambda-7(double a, double b) {
            return a - b;
        }

        private static final double registerOperators$lambda-8(double d, double b) {
            return (long)b ^ 0xFFFFFFFFFFFFFFFFL;
        }

        private static final double registerOperators$lambda-9(double a, double b) {
            return Long.rotateLeft((long)a, (int)b);
        }

        private static final double registerOperators$lambda-10(double a, double b) {
            return Long.rotateRight((long)a, (int)b);
        }

        private static final double registerOperators$lambda-11(double a, double b) {
            return (long)a >> (int)b;
        }

        private static final double registerOperators$lambda-12(double a, double b) {
            return (long)a << (int)b;
        }

        private static final double registerOperators$lambda-13(double a, double b) {
            return (long)a >>> (int)b;
        }

        private static final double registerOperators$lambda-14(double a, double b) {
            return (long)a & (long)b;
        }

        private static final double registerOperators$lambda-15(double a, double b) {
            return (long)a ^ (long)b;
        }

        private static final double registerOperators$lambda-16(double a, double b) {
            return (long)a | (long)b;
        }

        private static final double registerFunctions$lambda-17(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.abs(p.next());
        }

        private static final double registerFunctions$lambda-18(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.acos(p.next());
        }

        private static final double registerFunctions$lambda-19(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.asin(p.next());
        }

        private static final double registerFunctions$lambda-20(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.atan(p.next());
        }

        private static final double registerFunctions$lambda-21(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.cbrt(p.next());
        }

        private static final double registerFunctions$lambda-22(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.ceil(p.next());
        }

        private static final double registerFunctions$lambda-23(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.cos(p.next());
        }

        private static final double registerFunctions$lambda-24(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.cosh(p.next());
        }

        private static final double registerFunctions$lambda-25(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.exp(p.next());
        }

        private static final double registerFunctions$lambda-26(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.expm1(p.next());
        }

        private static final double registerFunctions$lambda-27(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.floor(p.next());
        }

        private static final double registerFunctions$lambda-28(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.getExponent(p.next());
        }

        private static final double registerFunctions$lambda-29(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.log(p.next());
        }

        private static final double registerFunctions$lambda-30(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.log10(p.next());
        }

        private static final double registerFunctions$lambda-31(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.log1p(p.next());
        }

        private static final double registerFunctions$lambda-32(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            double a = p.next();
            double b = p.next();
            return a >= b ? a : b;
        }

        private static final double registerFunctions$lambda-33(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            double a = p.next();
            double b = p.next();
            return a <= b ? a : b;
        }

        private static final double registerFunctions$lambda-34(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.nextUp(p.next());
        }

        private static final double registerFunctions$lambda-35(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.nextDown(p.next());
        }

        private static final double registerFunctions$lambda-36(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.nextAfter(p.next(), p.next());
        }

        private static final double registerFunctions$lambda-37(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return ThreadLocalRandom.current().nextDouble(p.next(), p.next() + 1.0);
        }

        private static final double registerFunctions$lambda-38(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return ThreadLocalRandom.current().nextInt((int)p.next(), (int)p.next() + 1);
        }

        private static final double registerFunctions$lambda-39(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.round(p.next());
        }

        private static final double registerFunctions$lambda-40(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.rint(p.next());
        }

        private static final double registerFunctions$lambda-41(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.signum(p.next());
        }

        private static final double registerFunctions$lambda-42(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() / p.next() * (double)100;
        }

        private static final double registerFunctions$lambda-43(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() / (double)100 * p.next();
        }

        private static final double registerFunctions$lambda-44(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.sin(p.next());
        }

        private static final double registerFunctions$lambda-45(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.sinh(p.next());
        }

        private static final double registerFunctions$lambda-46(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Double.doubleToRawLongBits(p.next());
        }

        private static final double registerFunctions$lambda-47(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Double.hashCode(p.next());
        }

        private static final double registerFunctions$lambda-48(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return System.identityHashCode(p.next());
        }

        private static final double registerFunctions$lambda-49(FnArgs it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return System.currentTimeMillis();
        }

        private static final double registerFunctions$lambda-50(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.sqrt(p.next());
        }

        private static final double registerFunctions$lambda-51(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.tan(p.next());
        }

        private static final double registerFunctions$lambda-52(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.tanh(p.next());
        }

        private static final double registerFunctions$lambda-53(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.toDegrees(p.next());
        }

        private static final double registerFunctions$lambda-54(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.toRadians(p.next());
        }

        private static final double registerFunctions$lambda-55(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.ulp(p.next());
        }

        private static final double registerFunctions$lambda-56(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.scalb(p.next(), (int)p.next());
        }

        private static final double registerFunctions$lambda-57(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.hypot(p.next(), p.next());
        }

        private static final double registerFunctions$lambda-58(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.copySign(p.next(), p.next());
        }

        private static final double registerFunctions$lambda-59(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Math.IEEEremainder(p.next(), p.next());
        }

        private static final double registerFunctions$lambda-60(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            int n = (int)p.next();
            return (double)(n * (n + 1)) / 2.0;
        }

        private static final double registerFunctions$lambda-61(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Long.reverse((long)p.next());
        }

        private static final double registerFunctions$lambda-62(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return Long.reverseBytes((long)p.next());
        }

        private static final double registerFunctions$lambda-63(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() == p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda-64(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return !(p.next() == p.next()) ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda-65(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() > p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda-66(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() < p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda-67(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() >= p.next() ? p.next() : p.next(3);
        }

        private static final double registerFunctions$lambda-68(FnArgs p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return p.next() <= p.next() ? p.next() : p.next(3);
        }

        private static final boolean findFunction$lambda-69(String $lowerCaseName, String x) {
            Intrinsics.checkNotNullParameter((Object)$lowerCaseName, (String)"$lowerCaseName");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            String string = x.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return Intrinsics.areEqual((Object)$lowerCaseName, (Object)string);
        }

        private static final boolean findFunction$lambda-71$lambda-70(String $lowerCaseName, String x) {
            Intrinsics.checkNotNullParameter((Object)$lowerCaseName, (String)"$lowerCaseName");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            String string = x.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String fn = string;
            return StringsKt.contains$default((CharSequence)$lowerCaseName, (CharSequence)fn, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)fn, (CharSequence)$lowerCaseName, (boolean)false, (int)2, null);
        }

        private static final String findFunction$lambda-71(String $lowerCaseName) {
            Intrinsics.checkNotNullParameter((Object)$lowerCaseName, (String)"$lowerCaseName");
            return FUNCTIONS.keySet().stream().filter(arg_0 -> Companion.findFunction$lambda-71$lambda-70($lowerCaseName, arg_0)).findFirst().orElse(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Arity.values().length];
            nArray[Arity.BINARY.ordinal()] = 1;
            nArray[Arity.UNARY.ordinal()] = 2;
            nArray[Arity.UNARY_AND_BINARY.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

