/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.network;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.cache.CachedValue;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.network.CommitDifference;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aJ)\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u001b\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0019H\u0007\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0!H\u0007\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\bH\u0007J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/kingdoms/utils/network/JSONRequester;", "", "()V", "API_URL", "Ljava/net/URL;", "getAPI_URL$annotations", "MASTER_SHA", "Lorg/kingdoms/utils/cache/CachedValue;", "", "getMASTER_SHA$annotations", "getMASTER_SHA", "()Lorg/kingdoms/utils/cache/CachedValue;", "USER_AGENT", "downloadFile", "", "link", "to", "Ljava/nio/file/Path;", "downloadGitHubFile", "", "path", "get", "T", "url", "rootType", "Ljava/lang/Class;", "(Ljava/net/URL;Ljava/lang/Class;)Ljava/lang/Object;", "urlString", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getDifference", "Lorg/kingdoms/utils/network/CommitDifference;", "lastCommit", "folderFilter", "", "(Ljava/lang/String;[Ljava/lang/String;)Lorg/kingdoms/utils/network/CommitDifference;", "getMasterSHA", "inputStreamToString", "input", "Ljava/io/InputStream;", "core"})
public final class JSONRequester {
    @NotNull
    public static final JSONRequester INSTANCE;
    @NotNull
    private static final URL API_URL;
    @NotNull
    private static final String USER_AGENT;
    @NotNull
    private static final CachedValue<String> MASTER_SHA;

    private JSONRequester() {
    }

    @JvmStatic
    public static final <T> T get(@NotNull String urlString, @NotNull Class<T> rootType) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        return JSONRequester.get(new URL(urlString), rootType);
    }

    @JvmStatic
    public static final <T> T get(@NotNull URL url, @NotNull Class<T> rootType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(rootType, (String)"rootType");
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("User-Agent", USER_AGENT);
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            object = new Gson().fromJson((Reader)reader, rootType);
        }
        catch (Throwable ex) {
            StringBuilder stringBuilder = new StringBuilder().append("Failed to fetch JSON '");
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.getInputStream()");
            throw new IllegalStateException(stringBuilder.append(INSTANCE.inputStreamToString(inputStream)).toString(), ex);
        }
        return (T)object;
    }

    private final String inputStreamToString(InputStream input) {
        String string = new BufferedReader(new InputStreamReader(input)).lines().collect(Collectors.joining("\n"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BufferedReader(InputStre\u2026Collectors.joining(\"\\n\"))");
        return string;
    }

    @JvmStatic
    private static /* synthetic */ void getAPI_URL$annotations() {
    }

    @NotNull
    public static final CachedValue<String> getMASTER_SHA() {
        return MASTER_SHA;
    }

    @JvmStatic
    public static /* synthetic */ void getMASTER_SHA$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final CommitDifference getDifference(@NotNull String lastCommit, @NotNull String[] folderFilter) {
        Intrinsics.checkNotNullParameter((Object)lastCommit, (String)"lastCommit");
        Intrinsics.checkNotNullParameter((Object)folderFilter, (String)"folderFilter");
        JsonObject json = JSONRequester.get("https://api.github.com/repos/CryptoMorin/KingdomsX/compare/" + lastCommit + "...master?per_page=1", JsonObject.class);
        String htmlURL = json.get("html_url").getAsString();
        int totalCommitDiff = json.get("total_commits").getAsInt();
        List files = new ArrayList();
        for (JsonElement file : json.get("files").getAsJsonArray()) {
            String filterStart;
            String string;
            String fileName;
            block2: {
                fileName = file.getAsJsonObject().get("filename").getAsString();
                String[] stringArray = folderFilter;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string2;
                    String x = string2 = stringArray[i];
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                    if (!StringsKt.startsWith$default((String)fileName, (String)x, (boolean)false, (int)2, null)) continue;
                    string = string2;
                    break block2;
                }
                string = null;
            }
            if ((filterStart = string) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            String string3 = fileName.substring(filterStart.length());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            files.add(string3);
        }
        Intrinsics.checkNotNullExpressionValue((Object)htmlURL, (String)"htmlURL");
        return new CommitDifference(lastCommit, "master", totalCommitDiff, htmlURL, files);
    }

    @JvmStatic
    public static final boolean downloadGitHubFile(@NotNull String path, @NotNull Path to) throws IOException {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        URL url = new URL("https://github.com/CryptoMorin/KingdomsX/blob/master/" + path + "?raw=true");
        try {
            INSTANCE.downloadFile(url, to);
            bl = true;
        }
        catch (FileNotFoundException ex) {
            bl = false;
        }
        return bl;
    }

    public final void downloadFile(@NotNull URL link, @NotNull Path to) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        KLogger.debug((DebugNS)KingdomsDebug.DOWNLOAD, "Downloading: " + link);
        ReadableByteChannel readableByteChannel = Channels.newChannel(link.openStream());
        Intrinsics.checkNotNullExpressionValue((Object)readableByteChannel, (String)"newChannel(link.openStream())");
        ReadableByteChannel readChan = readableByteChannel;
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
        FileChannel output = FileChannel.open(to, openOptionArray);
        output.transferFrom(readChan, 0L, Long.MAX_VALUE);
        readChan.close();
        output.close();
    }

    @JvmStatic
    @NotNull
    public static final String getMasterSHA() {
        String string;
        try {
            JsonObject res = JSONRequester.get(API_URL, JsonObject.class);
            string = res.get("sha").getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n        val res = get(\u2026res[\"sha\"].asString\n    }");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return string;
    }

    private static final String MASTER_SHA$lambda-0() {
        return JSONRequester.getMasterSHA();
    }

    static {
        URL uRL;
        INSTANCE = new JSONRequester();
        try {
            uRL = new URL("https://api.github.com/repos/CryptoMorin/KingdomsX/commits/master?per_page=1");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        API_URL = uRL;
        USER_AGENT = "KingdomsX/" + Kingdoms.get().getDescription().getVersion() + " (" + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("java.vendor") + "; " + System.getProperty("java.version") + ") " + Bukkit.getName() + '/' + Bukkit.getVersion() + " (" + Bukkit.getBukkitVersion() + ')';
        KLogger.debug((DebugNS)KingdomsDebug.DOWNLOAD, "User-Agent: " + USER_AGENT);
        Supplier<String> supplier = JSONRequester::MASTER_SHA$lambda-0;
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(1)");
        MASTER_SHA = new CachedValue<String>(supplier, duration);
    }
}

