/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.nms;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.kingdoms.libs.xseries.ReflectionUtils;

public final class EntityFactory {
    private static final MethodHandle SPAWN_PACKET;
    private static final MethodHandle CREATE_ENTITY;
    private static final MethodHandle ADD_ENTITY;
    private static final MethodHandle GET_BUKKIT_ENTITY;
    private static final MethodHandle DESTROY_PACKET;
    private static final MethodHandle GET_NMS_WORLD;
    private static final Set<Entity> TEMPORARY_ENTITIES;

    public static void addTemporaryEntity(Entity entity) {
        Objects.requireNonNull(entity);
        TEMPORARY_ENTITIES.add(entity);
    }

    public static void removeAllTemporaryEntities() {
        TEMPORARY_ENTITIES.forEach(Entity::remove);
    }

    public static Object getNMSWorld(World world) {
        try {
            return GET_NMS_WORLD.invoke(world);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Entity> T createEntity(Location location, EntityType type) {
        try {
            Object nmsEntity = CREATE_ENTITY.invoke(location.getWorld(), location, type.getEntityClass());
            return EntityFactory.getBukkitEntity(nmsEntity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static <T extends Entity> T getBukkitEntity(Object nmsEntity) {
        try {
            return (T)GET_BUKKIT_ENTITY.invoke(nmsEntity);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void removeEntity(Collection<? extends Player> players, List<Integer> entities) {
        Object packet;
        try {
            void var4_5;
            int[] ids = new int[entities.size()];
            boolean bl = false;
            while (var4_5 < entities.size()) {
                ids[var4_5] = entities.get((int)var4_5);
                ++var4_5;
            }
            packet = DESTROY_PACKET.invoke(ids);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
        for (Player player : players) {
            ReflectionUtils.sendPacketSync(player, packet);
        }
    }

    public static Object createSpawnPacket(Object nmsLivingEntity) {
        try {
            return SPAWN_PACKET.invoke(nmsLivingEntity);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addEntity(World world, Entity entity) {
        try {
            ADD_ENTITY.invoke(world, entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        Class<?> craftWorldClass = ReflectionUtils.getCraftClass("CraftWorld");
        Class<?> WorldServer = ReflectionUtils.getNMSClass("server.level", "WorldServer");
        Class<?> nmsEntity = ReflectionUtils.getNMSClass("world.entity", "Entity");
        Class<?> craftEntity = ReflectionUtils.getCraftClass("entity.CraftEntity");
        Class<?> NMSEntityLiving = ReflectionUtils.getNMSClass("world.entity", "EntityLiving");
        Class<?> PacketPlayOutEntityDestroy = ReflectionUtils.getNMSClass("network.protocol.game", "PacketPlayOutEntityDestroy");
        Class<?> packetSpawnClass = ReflectionUtils.getNMSClass("network.protocol.game", ReflectionUtils.v(19, "PacketPlayOutSpawnEntity").orElse("PacketPlayOutSpawnEntityLiving"));
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle createEntity = null;
        MethodHandle getNMSWorld = null;
        MethodHandle addEntity = null;
        MethodHandle getBukkitEntity = null;
        MethodHandle destroyPacket = null;
        MethodHandle spawnPacket = null;
        try {
            getNMSWorld = lookup.findVirtual(craftWorldClass, "getHandle", MethodType.methodType(WorldServer));
            spawnPacket = lookup.findConstructor(packetSpawnClass, ReflectionUtils.v(19, MethodType.methodType(Void.TYPE, nmsEntity)).orElse(MethodType.methodType(Void.TYPE, NMSEntityLiving)));
            createEntity = lookup.findVirtual(craftWorldClass, "createEntity", MethodType.methodType(nmsEntity, Location.class, Class.class));
            getBukkitEntity = lookup.findVirtual(nmsEntity, "getBukkitEntity", MethodType.methodType(craftEntity));
            addEntity = lookup.findVirtual(craftWorldClass, "addEntity", MethodType.methodType(Entity.class, nmsEntity, CreatureSpawnEvent.SpawnReason.class));
            destroyPacket = lookup.findConstructor(PacketPlayOutEntityDestroy, MethodType.methodType(Void.TYPE, int[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        GET_NMS_WORLD = getNMSWorld;
        SPAWN_PACKET = spawnPacket;
        GET_BUKKIT_ENTITY = getBukkitEntity;
        CREATE_ENTITY = createEntity;
        ADD_ENTITY = addEntity;
        DESTROY_PACKET = destroyPacket.asFixedArity();
        TEMPORARY_ENTITIES = Collections.newSetFromMap(new WeakHashMap());
    }
}

