/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.string.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.string.tree.ContainerPrinter;
import org.kingdoms.utils.string.tree.EntryPrinter;
import org.kingdoms.utils.string.tree.PrinterContext;
import org.kingdoms.utils.string.tree.StringPrinter;
import org.kingdoms.utils.string.tree.StringTreeKt;
import org.kingdoms.utils.string.tree.TreeColorScheme;
import org.kingdoms.utils.string.tree.TreeStyle;
import org.kingdoms.utils.string.tree.TreeTokenType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0000J\u000e\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0011J\b\u0010(\u001a\u00020\u000fH\u0016J\u0016\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u000fJ\u0016\u0010,\u001a\u00020$2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/R\u001e\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\f\u0012\b\u0012\u00060\bj\u0002`\t0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0013\"\u0004\b \u0010\u0015\u00a8\u00061"}, d2={"Lorg/kingdoms/utils/string/tree/StringTree;", "", "root", "Lorg/kingdoms/utils/string/tree/EntryPrinter;", "style", "Lorg/kingdoms/utils/string/tree/TreeStyle;", "(Lorg/kingdoms/utils/string/tree/EntryPrinter;Lorg/kingdoms/utils/string/tree/TreeStyle;)V", "currentBuilder", "Ljava/lang/StringBuilder;", "Lorg/kingdoms/libs/kotlin/text/StringBuilder;", "getCurrentBuilder", "()Ljava/lang/StringBuilder;", "setCurrentBuilder", "(Ljava/lang/StringBuilder;)V", "entryColor", "", "linePosition", "", "getLinePosition", "()I", "setLinePosition", "(I)V", "lines", "Ljava/util/ArrayList;", "getLines", "()Ljava/util/ArrayList;", "separator", "separatorColor", "getStyle$core", "()Lorg/kingdoms/utils/string/tree/TreeStyle;", "totalEntries", "getTotalEntries$core", "setTotalEntries$core", "flatten", "entry", "newLine", "", "print", "revertLinePosition", "newLinePos", "toString", "writeEntry", "nestLevel", "name", "writeIndicator", "", "type", "Lorg/kingdoms/utils/string/tree/TreeTokenType;", "Companion", "core"})
public class StringTree {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private EntryPrinter root;
    @NotNull
    private final TreeStyle style;
    @NotNull
    private final String entryColor;
    @NotNull
    private final String separator;
    @NotNull
    private final String separatorColor;
    @NotNull
    private final ArrayList<StringBuilder> lines;
    @NotNull
    private StringBuilder currentBuilder;
    private int linePosition;
    private int totalEntries;
    @NotNull
    private static final Map<TreeTokenType, String> ASCII_CHARACTER_SET;
    @NotNull
    private static final Map<TreeTokenType, String> UTF_CHARACTER_SET;

    public StringTree(@NotNull EntryPrinter root, @NotNull TreeStyle style) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.root = root;
        this.style = style;
        this.entryColor = StringTreeKt.getOrEmpty(this.style.getColors(), TreeColorScheme.ENTRIES);
        this.separator = this.style.getCharacters().getOrDefault((Object)TreeTokenType.INDICATOR_PATH_SEPARATOR, "/");
        this.separatorColor = StringTreeKt.getOrEmpty(this.style.getColors(), TreeColorScheme.PATH_SEPARATORS);
        this.lines = new ArrayList(10);
        this.currentBuilder = new StringBuilder(100);
        if (this.style.getFlatten()) {
            this.root = this.flatten(this.root);
        }
        this.style.validate();
        this.lines.add(this.currentBuilder);
    }

    @NotNull
    public final TreeStyle getStyle$core() {
        return this.style;
    }

    public final void writeIndicator(boolean writeIndicator, @NotNull TreeTokenType type) {
        TreeTokenType[] treeTokenTypeArray;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        String color = StringTreeKt.getOrEmpty(this.style.getColors(), TreeColorScheme.INDICATORS);
        String characters = StringTreeKt.getOrEmpty(this.style.getCharacters(), type);
        this.currentBuilder.append(color).append(characters);
        if (writeIndicator && this.style.getLines() != 0 && ArraysKt.contains((Object[])(treeTokenTypeArray = new TreeTokenType[]{TreeTokenType.INDICATOR_MIDDLE, TreeTokenType.INDICATOR_CORNERS_FIRST, TreeTokenType.INDICATOR_CORNERS_LAST}), (Object)((Object)type))) {
            String nest = StringTreeKt.getOrEmpty(this.style.getCharacters(), TreeTokenType.INDICATOR_HORIZONTAL_LINE);
            this.currentBuilder.append(StringsKt.repeat((CharSequence)nest, (int)this.style.getLines()));
        }
    }

    public final void writeEntry(int nestLevel, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BiFunction<Integer, String, String> biFunction = this.style.getEntryModifier();
        String string = biFunction != null ? biFunction.apply(nestLevel, name) : null;
        if (string == null) {
            string = name;
        }
        String name2 = string;
        this.currentBuilder.append(this.entryColor).append(name2);
        int n = this.totalEntries;
        this.totalEntries = n + 1;
    }

    private final EntryPrinter flatten(EntryPrinter entry) {
        if (entry instanceof ContainerPrinter) {
            if (((ContainerPrinter)entry).getChildren$core().size() == 1) {
                EntryPrinter entryPrinter;
                EntryPrinter flat = this.flatten((EntryPrinter)CollectionsKt.first(((ContainerPrinter)entry).getChildren$core()));
                String finalName = entry + this.separatorColor + this.separator + this.entryColor + flat;
                EntryPrinter entryPrinter2 = flat;
                if (entryPrinter2 instanceof ContainerPrinter) {
                    ((ContainerPrinter)flat).setName$core(finalName);
                    entryPrinter = flat;
                } else if (entryPrinter2 instanceof StringPrinter) {
                    entryPrinter = new StringPrinter(finalName);
                } else {
                    throw new IllegalStateException("Cannot flatten entry printer: " + flat);
                }
                return entryPrinter;
            }
            ContainerPrinter container = new ContainerPrinter(((ContainerPrinter)entry).getName$core());
            for (EntryPrinter child : ((ContainerPrinter)entry).getChildren$core()) {
                container.getChildren$core().add(this.flatten(child));
            }
            return container;
        }
        return entry;
    }

    public final void newLine() {
        int n = this.linePosition;
        this.linePosition = n + 1;
        if (this.linePosition == this.lines.size()) {
            this.currentBuilder = new StringBuilder(this.currentBuilder.length());
            this.lines.add(this.currentBuilder);
        } else {
            StringBuilder stringBuilder = this.lines.get(this.linePosition);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"lines[linePosition]");
            this.currentBuilder = stringBuilder;
        }
    }

    public final void revertLinePosition(int newLinePos) {
        this.linePosition = newLinePos;
        StringBuilder stringBuilder = this.lines.get(this.linePosition);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"lines[linePosition]");
        this.currentBuilder = stringBuilder;
    }

    @NotNull
    public final ArrayList<StringBuilder> getLines() {
        return this.lines;
    }

    @NotNull
    public final StringBuilder getCurrentBuilder() {
        return this.currentBuilder;
    }

    public final void setCurrentBuilder(@NotNull StringBuilder stringBuilder) {
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"<set-?>");
        this.currentBuilder = stringBuilder;
    }

    public final int getLinePosition() {
        return this.linePosition;
    }

    public final void setLinePosition(int n) {
        this.linePosition = n;
    }

    public final int getTotalEntries$core() {
        return this.totalEntries;
    }

    public final void setTotalEntries$core(int n) {
        this.totalEntries = n;
    }

    @NotNull
    public final StringTree print() {
        this.root.print(new PrinterContext(0, this, 1, 0));
        return this;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final Map<TreeTokenType, String> getASCII_CHARACTER_SET() {
        return Companion.getASCII_CHARACTER_SET();
    }

    @NotNull
    public static final Map<TreeTokenType, String> getUTF_CHARACTER_SET() {
        return Companion.getUTF_CHARACTER_SET();
    }

    static {
        EnumMap<TreeTokenType, String> enumMap;
        Companion = new Companion(null);
        EnumMap<TreeTokenType, String> $this$ASCII_CHARACTER_SET_u24lambda_u2d0 = enumMap = new EnumMap<TreeTokenType, String>(TreeTokenType.class);
        boolean bl = false;
        $this$ASCII_CHARACTER_SET_u24lambda_u2d0.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_VERTICAL_LINE), "|");
        $this$ASCII_CHARACTER_SET_u24lambda_u2d0.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_HORIZONTAL_LINE), "-");
        $this$ASCII_CHARACTER_SET_u24lambda_u2d0.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_CORNERS_FIRST), "+");
        $this$ASCII_CHARACTER_SET_u24lambda_u2d0.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_CORNERS_LAST), "+");
        $this$ASCII_CHARACTER_SET_u24lambda_u2d0.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_MIDDLE), "|");
        Map map = Collections.unmodifiableMap((Map)enumMap);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(EnumMap<\u2026DDLE, \"|\")\n            })");
        ASCII_CHARACTER_SET = map;
        EnumMap<TreeTokenType, String> $this$UTF_CHARACTER_SET_u24lambda_u2d1 = enumMap = new EnumMap(TreeTokenType.class);
        boolean bl2 = false;
        $this$UTF_CHARACTER_SET_u24lambda_u2d1.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_VERTICAL_LINE), "\u2502");
        $this$UTF_CHARACTER_SET_u24lambda_u2d1.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_HORIZONTAL_LINE), "\u2500");
        $this$UTF_CHARACTER_SET_u24lambda_u2d1.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_CORNERS_FIRST), "\u251c");
        $this$UTF_CHARACTER_SET_u24lambda_u2d1.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_CORNERS_LAST), "\u251c");
        $this$UTF_CHARACTER_SET_u24lambda_u2d1.put((TreeTokenType)((Enum)TreeTokenType.INDICATOR_MIDDLE), "\u251c");
        Map map2 = Collections.unmodifiableMap((Map)enumMap);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(EnumMap<\u2026DDLE, \"\u251c\")\n            })");
        UTF_CHARACTER_SET = map2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R(\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/kingdoms/utils/string/tree/StringTree$Companion;", "", "()V", "ASCII_CHARACTER_SET", "", "Lorg/kingdoms/utils/string/tree/TreeTokenType;", "", "getASCII_CHARACTER_SET$annotations", "getASCII_CHARACTER_SET", "()Ljava/util/Map;", "UTF_CHARACTER_SET", "getUTF_CHARACTER_SET$annotations", "getUTF_CHARACTER_SET", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<TreeTokenType, String> getASCII_CHARACTER_SET() {
            return ASCII_CHARACTER_SET;
        }

        @JvmStatic
        public static /* synthetic */ void getASCII_CHARACTER_SET$annotations() {
        }

        @NotNull
        public final Map<TreeTokenType, String> getUTF_CHARACTER_SET() {
            return UTF_CHARACTER_SET;
        }

        @JvmStatic
        public static /* synthetic */ void getUTF_CHARACTER_SET$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

