/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.animation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.property.SimpleProperty;
import com.ticxo.modelengine.api.animation.script.ScriptReader;
import com.ticxo.modelengine.api.animation.script.ScriptReaderRegistry;
import com.ticxo.modelengine.api.events.AnimationEndEvent;
import com.ticxo.modelengine.api.events.AnimationPlayEvent;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class PriorityHandler
implements AnimationHandler {
    private final ActiveModel model;
    private final Map<String, IAnimationProperty> properties = Maps.newConcurrentMap();
    private final List<IAnimationProperty> animations = new ArrayList<IAnimationProperty>();
    private List<IAnimationProperty> immutableAnimations;

    public PriorityHandler(ActiveModel activeModel) {
        this.model = activeModel;
    }

    @Override
    public void updateAll() {
        this.animations.clear();
        for (String string : this.model.getBlueprint().getAnimations().keySet()) {
            if (!this.properties.containsKey(string)) continue;
            IAnimationProperty iAnimationProperty = this.properties.get(string);
            if (iAnimationProperty != null && iAnimationProperty.update()) {
                this.animations.add(iAnimationProperty);
                continue;
            }
            ModelEngineAPI.callEvent(new AnimationEndEvent(this.model, iAnimationProperty));
            this.properties.remove(string);
        }
        try {
            this.immutableAnimations = ImmutableList.copyOf(this.animations);
        }
        catch (NullPointerException nullPointerException) {
            this.immutableAnimations = ImmutableList.of();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.immutableAnimations = ImmutableList.of();
        }
    }

    @Override
    public void tickEffects() {
        ScriptReaderRegistry scriptReaderRegistry = ModelEngineAPI.getScriptReaderRegistry();
        for (IAnimationProperty iAnimationProperty : this.getAnimations()) {
            List<ScriptKeyframe.Script> list;
            if (iAnimationProperty.getPhase() != IAnimationProperty.Phase.PLAY || (list = iAnimationProperty.getScriptFrame()) == null) continue;
            for (ScriptKeyframe.Script script : list) {
                String string = script.getReader();
                ScriptReader scriptReader = (ScriptReader)scriptReaderRegistry.get(string);
                if (scriptReader == null) continue;
                scriptReader.read(iAnimationProperty, script.getScript());
            }
        }
    }

    @Override
    public void forEachProperty(BiConsumer<String, IAnimationProperty> biConsumer) {
        this.properties.forEach(biConsumer);
    }

    @Override
    public IAnimationProperty getAnimation(String string) {
        return this.properties.get(string);
    }

    @Override
    public List<IAnimationProperty> getAnimations() {
        return this.immutableAnimations;
    }

    @Override
    public Vector getFinalPosition(ModelBone modelBone) {
        Object object;
        Object object3 = new Vector();
        for (IAnimationProperty object22 : this.getAnimations()) {
            object = object22.getPositionFrame(modelBone.getBoneId());
            if (!object22.isForceOverride() && !object22.isOverride()) {
                if (object == null) {
                    object = new Vector();
                }
                switch (object22.getPhase()) {
                    case LERPIN: {
                        object = TMath.lerp(new Vector(), (Vector)object, object22.getLerpInRatio());
                        break;
                    }
                    case LERPOUT: {
                        object = TMath.lerp((Vector)object, new Vector(), object22.getLerpOutRatio());
                    }
                }
                object3.add((Vector)object);
                continue;
            }
            if (object == null) continue;
            switch (object22.getPhase()) {
                case LERPIN: {
                    object3 = TMath.lerp(object3, (Vector)object, object22.getLerpInRatio());
                    break;
                }
                case PLAY: {
                    object3 = object;
                    break;
                }
                case LERPOUT: {
                    object3 = TMath.lerp((Vector)object, object3, object22.getLerpOutRatio());
                }
            }
        }
        BlueprintBone blueprintBone = modelBone.getBlueprintBone();
        object3.add(blueprintBone.getLocalOrigin());
        ModelBone modelBone2 = modelBone.getParent();
        if (modelBone2 != null) {
            Offset.getRelativeLocation(modelBone2.getRotation(), object3);
            Offset.rotateYaw(object3, Math.toRadians(modelBone2.getClientAproxYaw())).add(modelBone2.getPosition());
        } else {
            object = modelBone.getActiveModel().getModeledEntity();
            Offset.rotateYaw(object3, Math.toRadians(object.getBodyYaw())).add(object.getLocation());
        }
        return object3;
    }

    @Override
    public EulerAngle getFinalRotation(ModelBone modelBone) {
        EulerAngle eulerAngle;
        EulerAngle eulerAngle2 = EulerAngle.ZERO;
        for (IAnimationProperty object2 : this.getAnimations()) {
            eulerAngle = object2.getRotationFrame(modelBone.getBoneId());
            if (!object2.isForceOverride() && !object2.isOverride()) {
                if (eulerAngle == null) {
                    eulerAngle = EulerAngle.ZERO;
                }
                switch (object2.getPhase()) {
                    case LERPIN: {
                        eulerAngle = TMath.slerp(EulerAngle.ZERO, eulerAngle, object2.getLerpInRatio());
                        break;
                    }
                    case LERPOUT: {
                        eulerAngle = TMath.slerp(eulerAngle, EulerAngle.ZERO, object2.getLerpOutRatio());
                    }
                }
                eulerAngle2 = TMath.add(eulerAngle2, eulerAngle);
                continue;
            }
            if (eulerAngle == null) continue;
            switch (object2.getPhase()) {
                case LERPIN: {
                    if (eulerAngle.equals((Object)eulerAngle2)) break;
                    eulerAngle2 = TMath.slerp(eulerAngle2, eulerAngle, object2.getLerpInRatio());
                    break;
                }
                case PLAY: {
                    eulerAngle2 = eulerAngle;
                    break;
                }
                case LERPOUT: {
                    if (eulerAngle.equals((Object)eulerAngle2)) break;
                    eulerAngle2 = TMath.slerp(eulerAngle, eulerAngle2, object2.getLerpOutRatio());
                }
            }
        }
        ModelBone modelBone2 = modelBone.getParent();
        BlueprintBone blueprintBone = modelBone.getBlueprintBone();
        if (modelBone2 != null) {
            eulerAngle = modelBone2.getRotation();
            eulerAngle2 = TMath.localRotate(eulerAngle, TMath.add(eulerAngle2, blueprintBone.getLocalRotation()));
        } else {
            eulerAngle2 = TMath.add(eulerAngle2, blueprintBone.getLocalRotation());
        }
        if (!(modelBone2 != null && modelBone2.isHead() || !modelBone.isHead() || modelBone.getActiveModel().isLockPitch())) {
            eulerAngle2 = TMath.globalRotate(eulerAngle2, TMath.makeAngle(modelBone.getActiveModel().getModeledEntity().getHeadPitch(), 0.0, 0.0));
        }
        return eulerAngle2;
    }

    @Override
    public boolean playAnimation(String string, double d, double d2, double d3, boolean bl) {
        BlueprintAnimation blueprintAnimation = this.model.getBlueprint().getAnimations().get(string);
        if (blueprintAnimation == null) {
            return false;
        }
        return this.playAnimation(new SimpleProperty(this.model, blueprintAnimation, d, d2, d3), bl);
    }

    @Override
    public boolean playAnimation(IAnimationProperty iAnimationProperty, boolean bl) {
        AnimationPlayEvent animationPlayEvent = new AnimationPlayEvent(this.model, iAnimationProperty);
        ModelEngineAPI.callEvent(animationPlayEvent);
        if (animationPlayEvent.isCancelled()) {
            return false;
        }
        String string = iAnimationProperty.getName();
        if (!this.properties.containsKey(string)) {
            this.properties.put(string, iAnimationProperty);
            return true;
        }
        IAnimationProperty iAnimationProperty2 = this.properties.get(string);
        if (bl || iAnimationProperty2.getPhase() == IAnimationProperty.Phase.LERPOUT) {
            this.properties.put(string, iAnimationProperty);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPlayingAnimation(String string) {
        return this.properties.containsKey(string);
    }

    @Override
    public void stopAnimation(String string) {
        IAnimationProperty iAnimationProperty = this.properties.get(string);
        if (iAnimationProperty != null) {
            if (iAnimationProperty.getLerpOut() > 1.0E-5) {
                iAnimationProperty.stop();
            } else {
                this.forceStopAnimation(string);
            }
        }
    }

    @Override
    public void forceStopAnimation(String string) {
        this.properties.remove(string);
    }

    @Override
    public void forceStopAllAnimations() {
        this.properties.clear();
    }

    @Override
    public ActiveModel getModel() {
        return this.model;
    }
}

