/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api;

import com.google.gson.Gson;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeReaderRegistry;
import com.ticxo.modelengine.api.animation.script.ScriptReaderRegistry;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.BukkitEntity;
import com.ticxo.modelengine.api.entity.BukkitPlayer;
import com.ticxo.modelengine.api.entity.Dummy;
import com.ticxo.modelengine.api.generator.ModelGenerator;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.reader.BoneReaderManager;
import com.ticxo.modelengine.api.model.mananger.InteractionTicker;
import com.ticxo.modelengine.api.model.mananger.ModelRegistry;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.MountControllerRegistry;
import com.ticxo.modelengine.api.mount.MountPairManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.NMSHandler;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.network.NetworkHandler;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import com.ticxo.modelengine.api.utils.CompatibilityManager;
import com.ticxo.modelengine.api.utils.config.ConfigManager;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class ModelEngineAPI
extends JavaPlugin {
    public static ModelEngineAPI api;
    public static final Gson gson;
    protected static boolean hasViaVersion;
    protected String minecraftVersion;
    protected int versionNumber;
    protected PluginManager pluginManager;
    protected CompatibilityManager compatibilityManager;
    protected ConfigManager configManager;
    protected ModelRegistry modelRegistry;
    protected ModelGenerator generator;
    protected BoneReaderManager boneReader;
    protected ModelTicker modelTicker;
    protected VFXTicker vfxTicker;
    protected MountControllerRegistry controllerRegistry;
    protected MountPairManager mountManager;
    protected KeyframeReaderRegistry keyframeReaderRegistry;
    protected ScriptReaderRegistry scriptReaderRegistry;
    protected NMSHandler nms;
    protected InteractionTicker interactionTicker;

    public static void callEvent(Event event) {
        api.getPluginManager().callEvent(event);
    }

    public static ConfigManager getConfigManager() {
        return ModelEngineAPI.api.configManager;
    }

    public static EntityHandler getEntityHandler() {
        return api.getNms().getEntityHandler();
    }

    public static WorldHandler getWorldHandler() {
        return api.getNms().getWorldHandler();
    }

    public static NetworkHandler getNetworkHandler() {
        return api.getNms().getNetworkHandler();
    }

    public static ModelTicker getModelTicker() {
        return ModelEngineAPI.api.modelTicker;
    }

    public static VFXTicker getVFXTicker() {
        return ModelEngineAPI.api.vfxTicker;
    }

    public static MountControllerRegistry getControllerRegistry() {
        return ModelEngineAPI.api.controllerRegistry;
    }

    public static MountPairManager getMountManager() {
        return ModelEngineAPI.api.mountManager;
    }

    public static KeyframeReaderRegistry getKeyframeReaderRegistry() {
        return ModelEngineAPI.api.keyframeReaderRegistry;
    }

    public static ScriptReaderRegistry getScriptReaderRegistry() {
        return ModelEngineAPI.api.scriptReaderRegistry;
    }

    public static InteractionTicker getInteractionTicker() {
        return ModelEngineAPI.api.interactionTicker;
    }

    public static ModeledEntity createModeledEntity(Entity entity) {
        return ModelEngineAPI.createModeledEntity(new BukkitEntity(entity));
    }

    public static ModeledEntity createModeledEntity(Player player) {
        return ModelEngineAPI.createModeledEntity(new BukkitPlayer(player));
    }

    public static ModeledEntity createModeledEntity(BaseEntity<?> baseEntity) {
        return api.createModeledEntityImpl(baseEntity);
    }

    public static ModeledEntity getModeledEntity(UUID uUID) {
        return ModelEngineAPI.getModelTicker().getModeledEntity(uUID);
    }

    public static ModeledEntity getOrCreateModeledEntity(Entity entity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
        if (modeledEntity != null) {
            return modeledEntity;
        }
        return ModelEngineAPI.createModeledEntity(entity);
    }

    public static ActiveModel createActiveModel(String string) {
        ModelBlueprint modelBlueprint = ModelEngineAPI.getBlueprint(string);
        if (modelBlueprint == null) {
            TLogger.warn("Unable to create ActiveModel instance: Invalid model ID " + string);
            return null;
        }
        return ModelEngineAPI.createActiveModel(modelBlueprint);
    }

    public static ActiveModel createActiveModel(@NotNull ModelBlueprint modelBlueprint) {
        return api.createActiveModelImpl(modelBlueprint);
    }

    public static VFX createVFX(Entity entity) {
        return ModelEngineAPI.createVFX(new BukkitEntity(entity));
    }

    public static VFX createVFX(Player player) {
        return ModelEngineAPI.createVFX(new BukkitPlayer(player));
    }

    public static VFX createVFX(BaseEntity<?> baseEntity) {
        return api.createVFXImpl(baseEntity);
    }

    public static void registerModeledEntity(BaseEntity<?> baseEntity, ModeledEntity modeledEntity) {
        ModelEngineAPI.getModelTicker().registerModeledEntity(baseEntity, modeledEntity);
    }

    public static void removeModeledEntity(UUID uUID) {
        ModelEngineAPI.getModelTicker().removeModeledEntity(uUID);
    }

    public static boolean isModeledEntity(UUID uUID) {
        return ModelEngineAPI.getModelTicker().isModeledEntity(uUID);
    }

    public static ModelBlueprint getBlueprint(@NotNull String string) {
        return api.getModelRegistry().getBlueprint(string.toLowerCase(Locale.ENGLISH));
    }

    public static void registerMountedPair(Entity entity, ModeledEntity modeledEntity, MountController mountController) {
        ModelEngineAPI.api.mountManager.registerMountedPair(entity, modeledEntity, mountController);
    }

    public static void unregisterMountedPair(UUID uUID) {
        ModelEngineAPI.api.mountManager.unregisterMountedPair(uUID);
    }

    public static ModeledEntity getMountPair(UUID uUID) {
        return ModelEngineAPI.api.mountManager.getMountedPair(uUID);
    }

    public static MountController getPlayerMountController(UUID uUID) {
        return ModelEngineAPI.api.mountManager.getController(uUID);
    }

    public static Dummy createDummy() {
        return ModelEngineAPI.createDummy(UUID.randomUUID());
    }

    public static Dummy createDummy(UUID uUID) {
        return new Dummy(ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet(), uUID);
    }

    public static int getPlayerProtocolVersion(UUID uUID) {
        return api.playerProtocolVersion(uUID);
    }

    public abstract ModeledEntity createModeledEntityImpl(BaseEntity<?> var1);

    public abstract ActiveModel createActiveModelImpl(ModelBlueprint var1);

    public abstract VFX createVFXImpl(BaseEntity<?> var1);

    public abstract int playerProtocolVersion(UUID var1);

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public CompatibilityManager getCompatibilityManager() {
        return this.compatibilityManager;
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public ModelGenerator getGenerator() {
        return this.generator;
    }

    public BoneReaderManager getBoneReader() {
        return this.boneReader;
    }

    public NMSHandler getNms() {
        return this.nms;
    }

    public void setMinecraftVersion(String string) {
        this.minecraftVersion = string;
    }

    public void setVersionNumber(int n) {
        this.versionNumber = n;
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setCompatibilityManager(CompatibilityManager compatibilityManager) {
        this.compatibilityManager = compatibilityManager;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void setModelRegistry(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void setGenerator(ModelGenerator modelGenerator) {
        this.generator = modelGenerator;
    }

    public void setBoneReader(BoneReaderManager boneReaderManager) {
        this.boneReader = boneReaderManager;
    }

    public void setModelTicker(ModelTicker modelTicker) {
        this.modelTicker = modelTicker;
    }

    public void setVfxTicker(VFXTicker vFXTicker) {
        this.vfxTicker = vFXTicker;
    }

    public void setControllerRegistry(MountControllerRegistry mountControllerRegistry) {
        this.controllerRegistry = mountControllerRegistry;
    }

    public void setMountManager(MountPairManager mountPairManager) {
        this.mountManager = mountPairManager;
    }

    public void setKeyframeReaderRegistry(KeyframeReaderRegistry keyframeReaderRegistry) {
        this.keyframeReaderRegistry = keyframeReaderRegistry;
    }

    public void setScriptReaderRegistry(ScriptReaderRegistry scriptReaderRegistry) {
        this.scriptReaderRegistry = scriptReaderRegistry;
    }

    public void setNms(NMSHandler nMSHandler) {
        this.nms = nMSHandler;
    }

    public void setInteractionTicker(InteractionTicker interactionTicker) {
        this.interactionTicker = interactionTicker;
    }

    static {
        gson = new Gson();
    }
}

