/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.keyframe;

import com.ticxo.modelengine.api.animation.keyframe.DoubleData;
import com.ticxo.modelengine.api.animation.keyframe.IKeyframeData;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.api.utils.registry.TSingletonRegistry;
import java.util.function.Function;

public class KeyframeReaderRegistry
extends TSingletonRegistry<Function<String, IKeyframeData>> {
    public IKeyframeData tryParse(String string) {
        if (string == null) {
            return IKeyframeData.EMPTY;
        }
        if ((string = string.trim()).isEmpty()) {
            return IKeyframeData.EMPTY;
        }
        try {
            return new DoubleData(Double.parseDouble(string));
        }
        catch (NumberFormatException numberFormatException) {
            String[] stringArray = string.split(":", 2);
            if (stringArray.length == 1) {
                for (Function function : this.registry.values()) {
                    try {
                        return (IKeyframeData)function.apply(stringArray[0]);
                    }
                    catch (Throwable throwable) {
                    }
                }
            } else {
                Function function = (Function)this.get(stringArray[0]);
                if (function != null) {
                    try {
                        return (IKeyframeData)function.apply(stringArray[1]);
                    }
                    catch (Throwable throwable) {
                        TLogger.error(2, "------An error occurred while parsing the keyframe: " + string);
                        throwable.printStackTrace();
                    }
                } else {
                    for (Function function2 : this.registry.values()) {
                        try {
                            return (IKeyframeData)function2.apply(string);
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }
            TLogger.warn(2, "------Unknown keyframe data: " + string);
            return IKeyframeData.EMPTY;
        }
    }
}

