/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation.state;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.animation.blueprint.BlueprintAnimation;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.property.SimpleProperty;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ActiveModel;
import java.util.Map;

public class DefaultStateHandler {
    private final ActiveModel model;
    private final Map<ModelState, Property> properties = Maps.newConcurrentMap();

    public DefaultStateHandler(ActiveModel activeModel) {
        this.model = activeModel;
        this.properties.put(ModelState.IDLE, new Property(ModelState.IDLE.getString(), 0.25, 0.25, 1.0));
        this.properties.put(ModelState.WALK, new Property(ModelState.WALK.getString(), 0.25, 0.25, 1.0));
        this.properties.put(ModelState.JUMP, new Property(ModelState.JUMP.getString(), 0.25, 0.25, 1.0));
        this.properties.put(ModelState.SPAWN, new Property(ModelState.SPAWN.getString(), 0.0, 0.25, 1.0));
        this.properties.put(ModelState.DEATH, new Property(ModelState.DEATH.getString(), 0.25, 0.0, 1.0));
    }

    public void setProperty(ModelState modelState, Property property) {
        this.properties.put(modelState, property);
    }

    public Property getProperty(ModelState modelState) {
        return this.properties.get(modelState);
    }

    public ActiveModel getModel() {
        return this.model;
    }

    public static class Property {
        private final String animation;
        private final double lerpIn;
        private final double lerpOut;
        private final double speed;

        public IAnimationProperty build(ActiveModel activeModel) {
            BlueprintAnimation blueprintAnimation = activeModel.getBlueprint().getAnimations().get(this.animation);
            if (blueprintAnimation == null) {
                return null;
            }
            return new SimpleProperty(activeModel, blueprintAnimation, this.lerpIn, this.lerpOut, this.speed);
        }

        public Property(String string, double d, double d2, double d3) {
            this.animation = string;
            this.lerpIn = d;
            this.lerpOut = d2;
            this.speed = d3;
        }

        public String getAnimation() {
            return this.animation;
        }

        public double getLerpIn() {
            return this.lerpIn;
        }

        public double getLerpOut() {
            return this.lerpOut;
        }

        public double getSpeed() {
            return this.speed;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Property)) {
                return false;
            }
            Property property = (Property)object;
            if (!property.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getLerpIn(), property.getLerpIn()) != 0) {
                return false;
            }
            if (Double.compare(this.getLerpOut(), property.getLerpOut()) != 0) {
                return false;
            }
            if (Double.compare(this.getSpeed(), property.getSpeed()) != 0) {
                return false;
            }
            String string = this.getAnimation();
            String string2 = property.getAnimation();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        protected boolean canEqual(Object object) {
            return object instanceof Property;
        }

        public int hashCode() {
            int n = 59;
            int n2 = 1;
            long l = Double.doubleToLongBits(this.getLerpIn());
            n2 = n2 * 59 + (int)(l >>> 32 ^ l);
            long l2 = Double.doubleToLongBits(this.getLerpOut());
            n2 = n2 * 59 + (int)(l2 >>> 32 ^ l2);
            long l3 = Double.doubleToLongBits(this.getSpeed());
            n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
            String string = this.getAnimation();
            n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
            return n2;
        }

        public String toString() {
            return "DefaultStateHandler.Property(animation=" + this.getAnimation() + ", lerpIn=" + this.getLerpIn() + ", lerpOut=" + this.getLerpOut() + ", speed=" + this.getSpeed() + ")";
        }
    }
}

