/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.mananger;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.utils.data.EntityData;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class ModelTicker
extends BukkitRunnable {
    private final ModelEngineAPI api;
    private final Map<Integer, UUID> entityIdLookup = Maps.newConcurrentMap();
    private final Map<UUID, ModeledEntity> uuidLookup = Maps.newConcurrentMap();
    private final Map<UUID, SubHitbox> subHitboxLookup = Maps.newConcurrentMap();
    private final Map<Runnable, Long> queuedTasks = Maps.newConcurrentMap();

    public void start() {
        this.runTaskTimerAsynchronously((Plugin)this.api, 0L, 1L);
    }

    public void queueTask(Runnable runnable) {
        this.queuedTasks.put(runnable, System.currentTimeMillis());
    }

    public void run() {
        Object object;
        long l = System.currentTimeMillis();
        for (Runnable object2 : this.queuedTasks.keySet()) {
            object = this.queuedTasks.get(object2);
            if (object == null || l - (Long)object < 50L) continue;
            object2.run();
            this.queuedTasks.remove(object2);
        }
        for (UUID uUID : this.uuidLookup.keySet()) {
            object = this.uuidLookup.get(uUID);
            if (object == null || object.tick()) continue;
            object.getMountManager().dismountAll();
            object.destroy();
            this.entityIdLookup.remove(object.getBase().getEntityId());
            this.uuidLookup.remove(uUID);
        }
    }

    public void registerModeledEntity(BaseEntity<?> baseEntity, ModeledEntity modeledEntity) {
        this.entityIdLookup.put(baseEntity.getEntityId(), baseEntity.getUniqueId());
        this.uuidLookup.put(baseEntity.getUniqueId(), modeledEntity);
    }

    public void removeModeledEntity(UUID uUID) {
        ModeledEntity modeledEntity = this.uuidLookup.remove(uUID);
        if (modeledEntity == null) {
            return;
        }
        this.entityIdLookup.remove(modeledEntity.getBase().getEntityId());
        modeledEntity.destroy();
    }

    @Nullable
    public ModeledEntity getModeledEntity(int n) {
        return this.getModeledEntity(this.entityIdLookup.get(n));
    }

    @Nullable
    public ModeledEntity getModeledEntity(@Nullable UUID uUID) {
        return uUID == null ? null : this.uuidLookup.get(uUID);
    }

    public boolean isModeledEntity(int n) {
        return this.isModeledEntity(this.entityIdLookup.get(n));
    }

    public boolean isModeledEntity(@Nullable UUID uUID) {
        return uUID != null && this.uuidLookup.containsKey(uUID);
    }

    public void registerSubHitbox(UUID uUID, SubHitbox subHitbox) {
        this.subHitboxLookup.put(uUID, subHitbox);
    }

    public void registerSubHitbox(SubHitbox subHitbox) {
        this.subHitboxLookup.put(subHitbox.getSubHitboxEntity().getUniqueId(), subHitbox);
    }

    public void removeSubHitbox(UUID uUID) {
        this.subHitboxLookup.remove(uUID);
    }

    public SubHitbox getSubHitboxBone(UUID uUID) {
        return this.subHitboxLookup.get(uUID);
    }

    public boolean isSubHitbox(UUID uUID) {
        return this.subHitboxLookup.containsKey(uUID);
    }

    public boolean isModeledEntityOrSubHitbox(UUID uUID) {
        return this.isModeledEntity(uUID) || this.isSubHitbox(uUID);
    }

    public void saveAllModels() {
        for (ModeledEntity modeledEntity : this.uuidLookup.values()) {
            Entity entity;
            Object object = modeledEntity.getBase().getOriginal();
            if (!(object instanceof Entity) || (entity = (Entity)object) instanceof Player) continue;
            object = new EntityData();
            ((EntityData)object).save(modeledEntity);
            entity.getPersistentDataContainer().set(EntityData.DATA_KEY, PersistentDataType.STRING, (Object)ModelEngineAPI.gson.toJson(object));
        }
    }

    public Set<UUID> getAllModeledEntityUUID() {
        return this.uuidLookup.keySet();
    }

    public ModelTicker(ModelEngineAPI modelEngineAPI) {
        this.api = modelEngineAPI;
    }
}

