/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.mount;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.controller.MountController;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Entity;

public class MountPairManager {
    private final Map<UUID, ModeledEntity> mountedPair = Maps.newConcurrentMap();
    private final Map<UUID, MountController> controllers = Maps.newConcurrentMap();

    public void registerMountedPair(Entity entity, ModeledEntity modeledEntity, MountController mountController) {
        this.mountedPair.put(entity.getUniqueId(), modeledEntity);
        this.controllers.put(entity.getUniqueId(), mountController);
    }

    public void unregisterMountedPair(UUID uUID) {
        this.mountedPair.remove(uUID);
        this.controllers.remove(uUID);
    }

    public ModeledEntity getMountedPair(UUID uUID) {
        return this.mountedPair.get(uUID);
    }

    public MountController getController(UUID uUID) {
        return this.controllers.get(uUID);
    }
}

