/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils;

import com.google.common.io.ByteStreams;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class TFile {
    public static final String SEP = System.getProperty("file.separator");

    public static void copyResource(File file, String string) {
        if (!file.exists()) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                InputStream inputStream = ModelEngineAPI.api.getResource(string);
                if (inputStream != null) {
                    ByteStreams.copy((InputStream)inputStream, (OutputStream)fileOutputStream);
                }
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String createPath(String ... stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(SEP).append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static File createDirectory(File file, String ... stringArray) {
        File file2 = new File(file, TFile.createPath(stringArray));
        if (!file2.exists() && !file2.mkdirs()) {
            TLogger.log("Failed to create directory.");
        }
        return file2;
    }

    public static File createFile(File file, String ... stringArray) {
        File file2 = new File(file, TFile.createPath(stringArray));
        if (!file2.getParentFile().exists() && !file2.getParentFile().mkdirs()) {
            TLogger.log("Failed to create file.");
        }
        return file2;
    }

    public static BufferedImage toImage(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length > 1) {
            return TFile.rawToImage(stringArray[1]);
        }
        return TFile.rawToImage(string);
    }

    public static BufferedImage rawToImage(String string) {
        try {
            byte[] byArray = Base64.getDecoder().decode(string);
            return ImageIO.read(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static boolean isExtension(String string, String string2) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return false;
        }
        return string.substring(n + 1).equalsIgnoreCase(string2);
    }
}

