/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.registry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;

public abstract class TRegistry<T, R> {
    protected final Map<String, T> registry = Maps.newConcurrentMap();
    protected T defaultItem;

    public void register(String string, T t) {
        this.registry.put(string, t);
    }

    public void registerAndDefault(String string, T t) {
        this.registry.put(string, t);
        this.defaultItem = t;
    }

    public R get(String string) {
        if (!this.registry.containsKey(string)) {
            return this.getDefault();
        }
        return this.convert(this.registry.get(string));
    }

    public R getDefault() {
        return this.convert(this.defaultItem);
    }

    public Set<String> getKeys() {
        return this.registry.keySet();
    }

    protected abstract R convert(T var1);

    public void setDefaultItem(T t) {
        this.defaultItem = t;
    }
}

