/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.generator.parser.blockbench;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.error.WarnBadTranslation;
import com.ticxo.modelengine.api.error.WarnBoneTooLarge;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.generator.java.JavaItemModel;
import com.ticxo.modelengine.generator.parser.blockbench.component.BlockbenchTexture;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BlockbenchPackage {
    private final ModelBlueprint blueprint;
    private final List<BlockbenchTexture> texturesCache = Lists.newArrayList();
    private final Map<String, JavaItemModel> modelCache = new LinkedHashMap<String, JavaItemModel>();

    public void cleanUpElements() {
        for (JavaItemModel javaItemModel : this.modelCache.values()) {
            javaItemModel.normalizeModel(new WarnBoneTooLarge(javaItemModel.getName()), new WarnBadTranslation(javaItemModel.getName()));
            javaItemModel.cleanUpTextures();
        }
    }

    public BlockbenchPackage(ModelBlueprint modelBlueprint) {
        this.blueprint = modelBlueprint;
    }

    public ModelBlueprint getBlueprint() {
        return this.blueprint;
    }

    public List<BlockbenchTexture> getTexturesCache() {
        return this.texturesCache;
    }

    public Map<String, JavaItemModel> getModelCache() {
        return this.modelCache;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BlockbenchPackage)) {
            return false;
        }
        BlockbenchPackage blockbenchPackage = (BlockbenchPackage)object;
        if (!blockbenchPackage.canEqual(this)) {
            return false;
        }
        ModelBlueprint modelBlueprint = this.getBlueprint();
        ModelBlueprint modelBlueprint2 = blockbenchPackage.getBlueprint();
        if (modelBlueprint == null ? modelBlueprint2 != null : !modelBlueprint.equals(modelBlueprint2)) {
            return false;
        }
        List<BlockbenchTexture> list = this.getTexturesCache();
        List<BlockbenchTexture> list2 = blockbenchPackage.getTexturesCache();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        Map<String, JavaItemModel> map = this.getModelCache();
        Map<String, JavaItemModel> map2 = blockbenchPackage.getModelCache();
        return !(map == null ? map2 != null : !((Object)map).equals(map2));
    }

    protected boolean canEqual(Object object) {
        return object instanceof BlockbenchPackage;
    }

    public int hashCode() {
        int n = 59;
        int n2 = 1;
        ModelBlueprint modelBlueprint = this.getBlueprint();
        n2 = n2 * 59 + (modelBlueprint == null ? 43 : modelBlueprint.hashCode());
        List<BlockbenchTexture> list = this.getTexturesCache();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        Map<String, JavaItemModel> map = this.getModelCache();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        return n2;
    }

    public String toString() {
        return "BlockbenchPackage(blueprint=" + this.getBlueprint() + ", texturesCache=" + this.getTexturesCache() + ", modelCache=" + this.getModelCache() + ")";
    }
}

