/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.animation.PriorityHandler;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.AnimationHandler;
import com.ticxo.modelengine.api.animation.blueprint.LoopMode;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.animation.state.DefaultStateHandler;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.AnimationMode;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.handler.ItemHolderHandler;
import com.ticxo.modelengine.api.model.handler.LeashHandler;
import com.ticxo.modelengine.api.model.handler.MountHandler;
import com.ticxo.modelengine.api.model.handler.NametagHandler;
import com.ticxo.modelengine.api.model.handler.RendererHandler;
import com.ticxo.modelengine.api.model.handler.SubHitboxHandler;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@CommandAccessible(value={ActiveModel.class})
public class ActiveModelImpl
implements ActiveModel {
    protected static AnimationMode defaultMode = AnimationMode.C;
    private ModeledEntity modeledEntity;
    private final ModelBlueprint blueprint;
    private final AnimationHandler animationHandler;
    private final DefaultStateHandler defaultStateHandler;
    private final RendererHandler rendererHandler;
    private final MountHandler mountHandler;
    private final NametagHandler nametagHandler;
    private final LeashHandler leashHandler;
    private final SubHitboxHandler subHitboxHandler;
    private final ItemHolderHandler itemHolderHandler;
    private final Map<String, ModelBone> boneIndex = Maps.newConcurrentMap();
    private AnimationMode animationMode = defaultMode;
    private boolean canHurt = true;
    private boolean lockPitch = false;
    private boolean lockYaw = false;
    private boolean isSwappable = true;
    private boolean isGenerated;
    private final List<Runnable> queuedTask = new ArrayList<Runnable>();
    private final Set<BlueprintBone> loopedBones = Sets.newConcurrentHashSet();
    private final Set<BlueprintBone> bufferBones = Sets.newConcurrentHashSet();

    public static void updateConfigs() {
        defaultMode = ConfigProperty.ANIMATION_MODE.getAnimationMode();
    }

    public ActiveModelImpl(@NotNull ModelBlueprint modelBlueprint) {
        this.blueprint = modelBlueprint;
        this.animationHandler = new PriorityHandler(this);
        this.defaultStateHandler = new DefaultStateHandler(this);
        this.rendererHandler = new RendererHandler(this);
        this.mountHandler = new MountHandler(this);
        this.nametagHandler = new NametagHandler(this);
        this.leashHandler = new LeashHandler(this);
        this.subHitboxHandler = new SubHitboxHandler(this);
        this.itemHolderHandler = new ItemHolderHandler(this);
    }

    @Override
    public void safeRun(Runnable runnable) {
        if (this.isGenerated) {
            runnable.run();
        } else {
            this.queuedTask.add(runnable);
        }
    }

    @Override
    public void tick() {
        this.animationHandler.updateAll();
        this.tickBones();
        this.animationHandler.tickEffects();
        this.rendererHandler.update();
        this.mountHandler.update();
        this.nametagHandler.update();
        this.leashHandler.update();
        this.subHitboxHandler.update();
        this.itemHolderHandler.update();
    }

    @Override
    public void spawn() {
        if (!this.isGenerated) {
            return;
        }
        this.rendererHandler.spawn();
        this.mountHandler.spawn();
        this.nametagHandler.spawn();
        this.leashHandler.spawn();
        this.subHitboxHandler.spawn();
        this.itemHolderHandler.spawn();
    }

    @Override
    public void destroy() {
        if (!this.isGenerated) {
            return;
        }
        this.rendererHandler.despawn();
        this.mountHandler.despawn();
        this.nametagHandler.despawn();
        this.leashHandler.despawn();
        this.subHitboxHandler.despawn();
        this.itemHolderHandler.despawn();
    }

    @Override
    public ModelBone getBone(String string) {
        return this.boneIndex.get(string);
    }

    @Override
    public void showToPlayer(Player player) {
        if (!this.isGenerated) {
            return;
        }
        this.rendererHandler.spawn(player);
        this.mountHandler.spawn(player);
        this.nametagHandler.spawn(player);
        this.leashHandler.spawn(player);
        this.subHitboxHandler.spawn(player);
        this.itemHolderHandler.spawn(player);
    }

    @Override
    public void hideFromPlayer(Player player) {
        if (!this.isGenerated) {
            return;
        }
        this.rendererHandler.despawn(player);
        this.mountHandler.despawn(player);
        this.nametagHandler.despawn(player);
        this.leashHandler.despawn(player);
        this.subHitboxHandler.despawn(player);
        this.itemHolderHandler.despawn(player);
    }

    @Override
    public void setGlowing(boolean bl) {
        this.rendererHandler.setGlowing(bl);
    }

    @Override
    public void setHurt(boolean bl) {
        if (!this.canHurt) {
            return;
        }
        if (bl) {
            this.rendererHandler.setHurt();
        } else {
            this.rendererHandler.setWhite();
        }
    }

    @Override
    public void generateModel() {
        if (this.isGenerated) {
            this.rendererHandler.updateReference();
            this.mountHandler.updateReference();
            this.nametagHandler.updateReference();
            this.leashHandler.updateReference();
            this.subHitboxHandler.updateReference();
            this.itemHolderHandler.updateReference();
            return;
        }
        for (String object : this.blueprint.getBones().keySet()) {
            BlueprintBone blueprintBone = this.blueprint.getBones().get(object);
            this.generateBone(blueprintBone);
        }
        this.playDefaultAnimation(ModelState.IDLE);
        this.playDefaultAnimation(ModelState.SPAWN);
        this.animationHandler.updateAll();
        this.animationHandler.tickEffects();
        this.tickBones();
        this.rendererHandler.initialize();
        this.mountHandler.initialize();
        this.nametagHandler.initialize();
        this.leashHandler.initialize();
        this.subHitboxHandler.initialize();
        this.itemHolderHandler.initialize();
        this.isGenerated = true;
        for (Runnable runnable : new ArrayList<Runnable>(this.queuedTask)) {
            runnable.run();
        }
        this.queuedTask.clear();
    }

    @Override
    public void forceGenerateBone(String string, BlueprintBone blueprintBone) {
        ModelBone modelBone = this.boneIndex.get(string);
        if (modelBone == null) {
            return;
        }
        ModelBone modelBone2 = this.generateBone(blueprintBone);
        modelBone.addChild(modelBone2);
        modelBone2.spawn();
    }

    @Override
    public void removeBone(String string) {
        ModelBone modelBone = this.boneIndex.remove(string);
        if (modelBone == null) {
            return;
        }
        ModelBone modelBone2 = modelBone.getParent();
        if (modelBone2 != null) {
            modelBone2.removeChild(string);
        }
        modelBone.destroy();
    }

    @Override
    public void playDefaultAnimation(ModelState modelState) {
        switch (modelState) {
            case IDLE: {
                IAnimationProperty iAnimationProperty = this.defaultStateHandler.getProperty(ModelState.IDLE).build(this);
                if (iAnimationProperty == null) {
                    return;
                }
                iAnimationProperty.setForceLoopMode(LoopMode.LOOP);
                iAnimationProperty.setForceOverride(false);
                this.animationHandler.playAnimation(iAnimationProperty, true);
                this.animationHandler.stopAnimation(this.defaultStateHandler.getProperty(ModelState.WALK).getAnimation());
                if (!this.getModeledEntity().getBase().isOnGround()) break;
                this.animationHandler.stopAnimation(this.defaultStateHandler.getProperty(ModelState.JUMP).getAnimation());
                break;
            }
            case WALK: {
                IAnimationProperty iAnimationProperty = this.defaultStateHandler.getProperty(ModelState.WALK).build(this);
                if (iAnimationProperty == null) {
                    return;
                }
                iAnimationProperty.setForceLoopMode(LoopMode.LOOP);
                iAnimationProperty.setForceOverride(false);
                this.animationHandler.playAnimation(iAnimationProperty, true);
                this.animationHandler.stopAnimation(this.defaultStateHandler.getProperty(ModelState.IDLE).getAnimation());
                if (!this.getModeledEntity().getBase().isOnGround()) break;
                this.animationHandler.stopAnimation(this.defaultStateHandler.getProperty(ModelState.JUMP).getAnimation());
                break;
            }
            case JUMP: {
                IAnimationProperty iAnimationProperty = this.defaultStateHandler.getProperty(ModelState.JUMP).build(this);
                if (iAnimationProperty == null) {
                    return;
                }
                iAnimationProperty.setForceLoopMode(LoopMode.LOOP);
                iAnimationProperty.setForceOverride(true);
                this.animationHandler.playAnimation(iAnimationProperty, true);
                break;
            }
            case SPAWN: {
                IAnimationProperty iAnimationProperty = this.defaultStateHandler.getProperty(ModelState.SPAWN).build(this);
                if (iAnimationProperty == null) {
                    return;
                }
                iAnimationProperty.setForceLoopMode(LoopMode.ONCE);
                iAnimationProperty.setForceOverride(true);
                this.animationHandler.playAnimation(iAnimationProperty, true);
                break;
            }
            case DEATH: {
                this.animationHandler.forceStopAllAnimations();
                IAnimationProperty iAnimationProperty = this.defaultStateHandler.getProperty(ModelState.DEATH).build(this);
                if (iAnimationProperty == null) {
                    return;
                }
                iAnimationProperty.setForceLoopMode(LoopMode.HOLD);
                iAnimationProperty.setForceOverride(true);
                this.animationHandler.playAnimation(iAnimationProperty, true);
            }
        }
    }

    @Override
    public boolean hasAnimations() {
        if (this.animationHandler == null) {
            return false;
        }
        List<IAnimationProperty> list = this.animationHandler.getAnimations();
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (IAnimationProperty iAnimationProperty : list) {
            if (iAnimationProperty.isFinished() && iAnimationProperty.getName().equals(this.defaultStateHandler.getProperty(ModelState.DEATH).getAnimation())) continue;
            return true;
        }
        return false;
    }

    private void tickBones() {
        this.loopedBones.addAll(this.blueprint.getBones().values());
        while (!this.loopedBones.isEmpty()) {
            for (BlueprintBone blueprintBone : this.loopedBones) {
                this.bufferBones.addAll(blueprintBone.getChildren());
                ModelBone modelBone = this.boneIndex.get(blueprintBone.getName());
                if (modelBone == null) continue;
                modelBone.tick();
            }
            this.loopedBones.clear();
            this.loopedBones.addAll(this.bufferBones);
            this.bufferBones.clear();
        }
    }

    private ModelBone generateBone(BlueprintBone blueprintBone) {
        ModelBone modelBone = ModelEngineAPI.api.getBoneReader().createModelBone(blueprintBone, this);
        this.boneIndex.put(modelBone.getBoneId(), modelBone);
        for (BlueprintBone blueprintBone2 : blueprintBone.getChildren()) {
            modelBone.addChild(this.generateBone(blueprintBone2));
        }
        return modelBone;
    }

    @Override
    public ModeledEntity getModeledEntity() {
        return this.modeledEntity;
    }

    @Override
    public void setModeledEntity(ModeledEntity modeledEntity) {
        this.modeledEntity = modeledEntity;
    }

    @Override
    public ModelBlueprint getBlueprint() {
        return this.blueprint;
    }

    @Override
    public AnimationHandler getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public DefaultStateHandler getDefaultStateHandler() {
        return this.defaultStateHandler;
    }

    @Override
    public RendererHandler getRendererHandler() {
        return this.rendererHandler;
    }

    @Override
    public MountHandler getMountHandler() {
        return this.mountHandler;
    }

    @Override
    public NametagHandler getNametagHandler() {
        return this.nametagHandler;
    }

    @Override
    public LeashHandler getLeashHandler() {
        return this.leashHandler;
    }

    @Override
    public SubHitboxHandler getSubHitboxHandler() {
        return this.subHitboxHandler;
    }

    @Override
    public ItemHolderHandler getItemHolderHandler() {
        return this.itemHolderHandler;
    }

    @Override
    public Map<String, ModelBone> getBoneIndex() {
        return this.boneIndex;
    }

    @Override
    public AnimationMode getAnimationMode() {
        return this.animationMode;
    }

    @Override
    public void setAnimationMode(AnimationMode animationMode) {
        this.animationMode = animationMode;
    }

    @Override
    public boolean isCanHurt() {
        return this.canHurt;
    }

    @Override
    public void setCanHurt(boolean bl) {
        this.canHurt = bl;
    }

    @Override
    public boolean isLockPitch() {
        return this.lockPitch;
    }

    @Override
    public void setLockPitch(boolean bl) {
        this.lockPitch = bl;
    }

    @Override
    public boolean isLockYaw() {
        return this.lockYaw;
    }

    @Override
    public void setLockYaw(boolean bl) {
        this.lockYaw = bl;
    }

    @Override
    public boolean isSwappable() {
        return this.isSwappable;
    }

    @Override
    public void setSwappable(boolean bl) {
        this.isSwappable = bl;
    }

    @Override
    public boolean isGenerated() {
        return this.isGenerated;
    }
}

