/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.model;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.events.AddModelEvent;
import com.ticxo.modelengine.api.events.RemoveModelEvent;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.IModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.util.Consumer;
import org.bukkit.util.Vector;

@CommandAccessible(value={ModeledEntity.class, IModel.class})
public class ModeledEntityImpl
implements ModeledEntity {
    private final BaseEntity<?> base;
    private final RangeManager rangeManager;
    private final Map<String, ActiveModel> models = Maps.newConcurrentMap();
    private Vector location;
    private final MoveController moveController;
    private final LookController lookController;
    private final BodyRotationController bodyRotationController;
    private final MountManager mountManager;
    private boolean isBaseEntityVisible = true;
    private int hurtTick;
    private float headYaw;
    private float headPitch;
    private float bodyYaw;
    private boolean modelRotationLock = false;
    private ModelState state;
    private boolean isGlowing;
    private final boolean isInitialized;
    private final List<Runnable> queuedTask = new ArrayList<Runnable>();

    public ModeledEntityImpl(BaseEntity<?> baseEntity) {
        this.base = baseEntity;
        ModelEngineAPI.registerModeledEntity(this.base, this);
        this.location = this.base.getLocation().toVector();
        this.rangeManager = this.base.wrapRangeManager(this);
        this.mountManager = new MountManager(this);
        this.moveController = this.base.wrapMoveControl();
        this.lookController = this.base.wrapLookControl();
        this.bodyRotationController = this.base.wrapBodyRotationControl();
        this.base.wrapNavigation();
        this.getRotations();
        this.setState(ModelState.SPAWN);
        this.isInitialized = true;
        for (Runnable runnable : this.queuedTask) {
            runnable.run();
        }
        this.queuedTask.clear();
    }

    @Override
    public boolean tick() {
        if (!this.isInitialized) {
            return true;
        }
        this.location = this.base.getLocation().toVector();
        if (!this.modelRotationLock) {
            this.getRotations();
        }
        this.tickHurt();
        if (this.base.isDead()) {
            this.setState(ModelState.DEATH);
        } else {
            this.manualSetDefaultStates();
        }
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.safeRun(activeModel::tick);
        }
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::update));
        this.detectGlowingState();
        return !this.base.isDead() || this.getAnimationState(true);
    }

    @Override
    public void destroy() {
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.destroy();
        }
        this.models.clear();
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> {
            modelHitbox.despawn();
            modelHitbox.removeInteraction();
        }));
    }

    @Override
    public void setStepHeight(double d) {
        this.base.setStepHeight(d);
    }

    @Override
    public void setRenderRadius(int n) {
        this.rangeManager.setRenderDistance(n);
    }

    @Override
    public void setBaseEntityVisible(boolean bl) {
        if (this.isBaseEntityVisible == bl) {
            return;
        }
        this.isBaseEntityVisible = bl;
        if (bl) {
            this.base.broadcastSpawnPacket();
        } else {
            this.base.broadcastDespawnPacket();
        }
    }

    @Override
    public void showToPlayer(Player player) {
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.showToPlayer(player);
        }
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.spawn(player)));
    }

    @Override
    public void hideFromPlayer(Player player) {
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.hideFromPlayer(player);
        }
        this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)modelHitbox -> modelHitbox.despawn(player)));
    }

    @Override
    public void hurt() {
        this.hurtTick = 10;
    }

    @Override
    public void addModel(ActiveModel activeModel, boolean bl) {
        if (!activeModel.isSwappable()) {
            return;
        }
        try {
            AddModelEvent addModelEvent = new AddModelEvent(this, activeModel);
            addModelEvent.setOverrideHitbox(bl);
            ModelEngineAPI.callEvent(addModelEvent);
            if (addModelEvent.isCancelled()) {
                return;
            }
            activeModel.setSwappable(false);
            activeModel.setModeledEntity(this);
            this.models.put(activeModel.getBlueprint().getModelId(), activeModel);
            activeModel.generateModel();
            activeModel.setGlowing(this.isGlowing);
            if (addModelEvent.isOverrideHitbox()) {
                this.base.setHitbox(activeModel.getBlueprint().getMainHitbox());
            }
            this.updateModelHitbox((Consumer<ModelHitbox>)((Consumer)ModelHitbox::spawn));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public ActiveModel removeModel(String string) {
        ActiveModel activeModel = this.models.get(string);
        if (activeModel == null) {
            return null;
        }
        RemoveModelEvent removeModelEvent = new RemoveModelEvent(this, activeModel);
        ModelEngineAPI.callEvent(removeModelEvent);
        if (removeModelEvent.isCancelled()) {
            return null;
        }
        return this.models.remove(string);
    }

    @Override
    public ActiveModel getModel(String string) {
        return this.models.get(string);
    }

    @Override
    public boolean getAnimationState(boolean bl) {
        for (ActiveModel activeModel : this.models.values()) {
            if (!activeModel.hasAnimations()) continue;
            return bl;
        }
        return !bl;
    }

    @Override
    public void setState(ModelState modelState) {
        if (this.state == modelState) {
            return;
        }
        this.state = modelState;
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.playDefaultAnimation(modelState);
        }
    }

    @Override
    public void queuePostInitTask(Runnable runnable) {
        if (this.isInitialized) {
            runnable.run();
        } else {
            this.queuedTask.add(runnable);
        }
    }

    @Override
    public void updateModelHitbox(Consumer<ModelHitbox> consumer) {
        ModelHitbox modelHitbox = this.base.getModelHitbox();
        if (modelHitbox != null) {
            consumer.accept((Object)modelHitbox);
        }
    }

    private void tickHurt() {
        if (this.hurtTick < 0) {
            return;
        }
        switch (this.hurtTick) {
            case 10: {
                for (ActiveModel activeModel : this.models.values()) {
                    activeModel.safeRun(() -> activeModel.setHurt(true));
                }
                break;
            }
            case 0: {
                for (ActiveModel activeModel : this.models.values()) {
                    activeModel.safeRun(() -> activeModel.setHurt(false));
                }
                break;
            }
        }
        --this.hurtTick;
    }

    private void detectGlowingState() {
        if (this.isGlowing == this.base.isGlowing()) {
            return;
        }
        this.isGlowing = !this.isGlowing;
        for (ActiveModel activeModel : this.models.values()) {
            activeModel.safeRun(() -> activeModel.setGlowing(this.isGlowing));
        }
    }

    private void getRotations() {
        this.bodyRotationController.tick();
        this.headYaw = this.bodyRotationController.getYHeadRot();
        this.headPitch = this.bodyRotationController.getXHeadRot();
        this.bodyYaw = this.bodyRotationController.getYBodyRot();
    }

    private void manualSetDefaultStates() {
        MoveController moveController = this.moveController;
        if (moveController instanceof EmptyMoveController) {
            EmptyMoveController emptyMoveController = (EmptyMoveController)moveController;
            if (this.base.isMoving()) {
                emptyMoveController.resetIdleDelay();
                this.setState(ModelState.WALK);
            } else {
                this.setState(emptyMoveController.tickIdleDelay() ? ModelState.IDLE : ModelState.WALK);
            }
        }
    }

    @Override
    public BaseEntity<?> getBase() {
        return this.base;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public Map<String, ActiveModel> getModels() {
        return this.models;
    }

    @Override
    public Vector getLocation() {
        return this.location;
    }

    @Override
    public MoveController getMoveController() {
        return this.moveController;
    }

    @Override
    public LookController getLookController() {
        return this.lookController;
    }

    @Override
    public BodyRotationController getBodyRotationController() {
        return this.bodyRotationController;
    }

    @Override
    public MountManager getMountManager() {
        return this.mountManager;
    }

    @Override
    public boolean isBaseEntityVisible() {
        return this.isBaseEntityVisible;
    }

    @Override
    public float getHeadYaw() {
        return this.headYaw;
    }

    @Override
    public float getHeadPitch() {
        return this.headPitch;
    }

    @Override
    public float getBodyYaw() {
        return this.bodyYaw;
    }

    @Override
    public boolean isModelRotationLock() {
        return this.modelRotationLock;
    }

    @Override
    public void setModelRotationLock(boolean bl) {
        this.modelRotationLock = bl;
    }

    @Override
    public ModelState getState() {
        return this.state;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }
}

