/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic;

import com.ticxo.modelengine.ModelEngine;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.jetbrains.annotations.Nullable;

public class MythicUtils {
    public static String getOrNull(@Nullable PlaceholderString placeholderString) {
        return placeholderString == null ? null : placeholderString.get();
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, PlaceholderMeta placeholderMeta) {
        return placeholderString == null ? null : placeholderString.get(placeholderMeta);
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, AbstractEntity abstractEntity) {
        return placeholderString == null ? null : placeholderString.get(abstractEntity);
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, PlaceholderMeta placeholderMeta, AbstractEntity abstractEntity) {
        return placeholderString == null ? null : placeholderString.get(placeholderMeta, abstractEntity);
    }

    public static String getOrNull(@Nullable PlaceholderString placeholderString, SkillCaster skillCaster) {
        return placeholderString == null ? null : placeholderString.get(skillCaster);
    }

    public static Color getColor(@Nullable String string) {
        if (string == null) {
            return Color.WHITE;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        return Color.fromRGB((int)Integer.parseInt(string, 16));
    }

    public static ActiveModel getActiveModelOrNull(ModeledEntity modeledEntity, @Nullable String string) {
        return string == null ? null : modeledEntity.getModel(string.toLowerCase(Locale.ENGLISH));
    }

    public static ModelBlueprint getBlueprintOrNull(@Nullable String string) {
        return string == null ? null : ModelEngineAPI.getBlueprint(string);
    }

    public static ProjectileEntity getProjectileEntity(SkillMetadata skillMetadata) {
        IParentSkill iParentSkill = skillMetadata.getCallingEvent();
        if (!(iParentSkill instanceof Projectile.ProjectileTracker)) {
            return null;
        }
        Projectile.ProjectileTracker projectileTracker = (Projectile.ProjectileTracker)iParentSkill;
        return ModelEngine.core.getMythicSupport().getTrackers().get(projectileTracker);
    }

    public static UUID getVFXUniqueId(SkillMetadata skillMetadata) {
        ProjectileEntity projectileEntity = MythicUtils.getProjectileEntity(skillMetadata);
        if (projectileEntity != null) {
            return projectileEntity.getUniqueId();
        }
        return skillMetadata.getCaster().getEntity().getUniqueId();
    }

    public static void executeOptModelId(ModeledEntity modeledEntity, String string, Consumer<ActiveModel> consumer) {
        if (string == null) {
            for (ActiveModel activeModel : modeledEntity.getModels().values()) {
                consumer.accept(activeModel);
            }
        } else {
            ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
            if (activeModel != null) {
                consumer.accept(activeModel);
            }
        }
    }
}

