/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.api.mobs.entities.SpawnReason;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.adapters.BukkitEntityType;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.mobs.ActiveMob;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.util.Vector;

public class MechanicBindEntitySubHitbox
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final String strType;
    private MythicMob mm;
    private BukkitEntityType me;

    public MechanicBindEntitySubHitbox(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.strType = mythicLineConfig.getString(new String[]{"type", "t", "mob", "m"}, "SKELETON", new String[0]);
        this.getPlugin().getSkillManager().queueSecondPass(() -> {
            this.mm = this.getPlugin().getMobManager().getMythicMob(this.strType).orElse(null);
            if (this.mm == null) {
                this.me = BukkitEntityType.getMythicEntity((String)this.strType);
                if (this.me == null) {
                    MythicLogger.errorGenericConfig((MythicLineConfig)mythicLineConfig, (String)"The 'type' attribute must be a valid MythicMob or MythicEntity type.");
                }
            }
        });
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        SubHitbox subHitbox = (SubHitbox)activeModel.getSubHitboxHandler().getBones().get(string2);
        if (subHitbox == null) {
            return SkillResult.INVALID_CONFIG;
        }
        SkillCaster skillCaster = skillMetadata.getCaster();
        AbstractEntity abstractEntity2 = skillCaster.getEntity();
        AbstractLocation abstractLocation = BukkitAdapter.adapt((Vector)subHitbox.getPosition()).toLocation(abstractEntity2.getWorld());
        AbstractEntity abstractEntity3 = null;
        if (this.mm != null) {
            ActiveMob activeMob = this.mm.spawn(abstractLocation, skillCaster.getLevel(), SpawnReason.SUMMON);
            abstractEntity3 = activeMob.getEntity();
            activeMob.setParent(skillCaster);
            activeMob.setOwner(abstractEntity2.getUniqueId());
            SkillCaster skillCaster2 = skillMetadata.getCaster();
            if (skillCaster2 instanceof ActiveMob) {
                ActiveMob activeMob2 = (ActiveMob)skillCaster2;
                activeMob.setFaction(activeMob2.getFaction());
            }
        } else if (this.me != null) {
            abstractEntity3 = this.me.spawn(abstractLocation, SpawnReason.SUMMON, null);
        }
        if (abstractEntity3 == null || !abstractEntity3.isLiving()) {
            return SkillResult.CONDITION_FAILED;
        }
        subHitbox.bindEntity(abstractEntity3.getBukkitEntity());
        return SkillResult.SUCCESS;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return ThreadSafetyLevel.SYNC_ONLY;
    }
}

