/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderFloat;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicBodyRotation
implements ITargetedEntitySkill {
    private final MythicLineConfig config;

    public MechanicBodyRotation(MythicLineConfig mythicLineConfig) {
        this.config = mythicLineConfig;
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        BodyRotationController bodyRotationController = modeledEntity.getBodyRotationController();
        boolean bl = this.config.getBoolean(new String[]{"hu", "head", "headuneven"}, bodyRotationController.isHeadClampUneven());
        PlaceholderFloat placeholderFloat = this.config.getPlaceholderFloat(new String[]{"mh", "mxh", "maxhead"}, bodyRotationController.getMaxHeadAngle(), new String[0]);
        PlaceholderFloat placeholderFloat2 = this.config.getPlaceholderFloat(new String[]{"mnh", "minhead"}, bodyRotationController.getMinHeadAngle(), new String[0]);
        boolean bl2 = this.config.getBoolean(new String[]{"bu", "body", "bodyuneven"}, bodyRotationController.isBodyClampUneven());
        PlaceholderFloat placeholderFloat3 = this.config.getPlaceholderFloat(new String[]{"mb", "mxb", "maxbody"}, bodyRotationController.getMaxBodyAngle(), new String[0]);
        PlaceholderFloat placeholderFloat4 = this.config.getPlaceholderFloat(new String[]{"mnb", "minbody"}, bodyRotationController.getMinBodyAngle(), new String[0]);
        boolean bl3 = this.config.getBoolean(new String[]{"m", "mode", "player", "playermode"}, bodyRotationController.isPlayerMode());
        PlaceholderFloat placeholderFloat5 = this.config.getPlaceholderFloat(new String[]{"s", "stable"}, bodyRotationController.getStableAngle(), new String[0]);
        PlaceholderInt placeholderInt = this.config.getPlaceholderInteger(new String[]{"rde", "rdelay"}, bodyRotationController.getRotationDelay(), new String[0]);
        PlaceholderInt placeholderInt2 = this.config.getPlaceholderInteger(new String[]{"rdu", "rduration"}, bodyRotationController.getRotationDuration(), new String[0]);
        bodyRotationController.setHeadClampUneven(bl);
        bodyRotationController.setMaxHeadAngle(placeholderFloat.get((PlaceholderMeta)skillMetadata, abstractEntity));
        bodyRotationController.setMinHeadAngle(placeholderFloat2.get((PlaceholderMeta)skillMetadata, abstractEntity));
        bodyRotationController.setBodyClampUneven(bl2);
        bodyRotationController.setMaxBodyAngle(placeholderFloat3.get((PlaceholderMeta)skillMetadata, abstractEntity));
        bodyRotationController.setMinBodyAngle(placeholderFloat4.get((PlaceholderMeta)skillMetadata, abstractEntity));
        bodyRotationController.setPlayerMode(bl3);
        bodyRotationController.setStableAngle(placeholderFloat5.get((PlaceholderMeta)skillMetadata, abstractEntity));
        bodyRotationController.setRotationDelay(placeholderInt.get((PlaceholderMeta)skillMetadata, abstractEntity));
        bodyRotationController.setRotationDuration(placeholderInt2.get((PlaceholderMeta)skillMetadata, abstractEntity));
        return SkillResult.SUCCESS;
    }
}

