/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicChangePart
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString nModelId;
    private final PlaceholderString nPartId;

    public MechanicChangePart(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.nModelId = mythicLineConfig.getPlaceholderString(new String[]{"nm", "nmid", "newmodel", "newmodelid"}, null, new String[0]);
        this.nPartId = mythicLineConfig.getPlaceholderString(new String[]{"np", "npid", "newpart", "newpartid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        BoneRenderer boneRenderer = (BoneRenderer)activeModel.getRendererHandler().getFakeEntity().get(string2);
        if (boneRenderer == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string3 = MythicUtils.getOrNull(this.nModelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBlueprint modelBlueprint = MythicUtils.getBlueprintOrNull(string3);
        if (modelBlueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string4 = MythicUtils.getOrNull(this.nPartId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string4 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        Integer n = modelBlueprint.getItemIds().get(string4);
        if (n == null) {
            return SkillResult.INVALID_CONFIG;
        }
        boneRenderer.setData(n);
        return SkillResult.SUCCESS;
    }
}

