/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicConfigureHitbox
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderDouble shouldPass;

    public MechanicConfigureHitbox(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.shouldPass = mythicLineConfig.getPlaceholderDouble(new String[]{"pass"}, 1.0, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        SubHitbox subHitbox = (SubHitbox)activeModel.getSubHitboxHandler().getBones().get(string2);
        if (subHitbox == null) {
            return SkillResult.INVALID_CONFIG;
        }
        subHitbox.setDamageMultiplier(this.shouldPass.get((PlaceholderMeta)skillMetadata, abstractEntity));
        return SkillResult.SUCCESS;
    }
}

