/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.entity.Player;

public class MechanicDisguise
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final boolean viewSelf;

    public MechanicDisguise(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.viewSelf = mythicLineConfig.getBoolean(new String[]{"s", "see", "seeself"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        Object object;
        if (!abstractEntity.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)abstractEntity.getBukkitEntity();
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBlueprint modelBlueprint = MythicUtils.getBlueprintOrNull(string);
        if (modelBlueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            modeledEntity = ModelEngineAPI.createModeledEntity(player);
            modeledEntity.setBaseEntityVisible(false);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, true);
        }
        if (modeledEntity.getModel(string) != null) {
            return SkillResult.CONDITION_FAILED;
        }
        RangeManager rangeManager = modeledEntity.getRangeManager();
        if (rangeManager instanceof RangeManager.Disguise) {
            object = (RangeManager.Disguise)((Object)rangeManager);
            object.setIncludeSelf(this.viewSelf);
        }
        object = ModelEngineAPI.createActiveModel(modelBlueprint);
        modeledEntity.addModel((ActiveModel)object, true);
        return SkillResult.SUCCESS;
    }
}

