/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicSubModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString parentId;
    private final PlaceholderString childId;
    private final boolean remove;

    public MechanicSubModel(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.parentId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.childId = mythicLineConfig.getPlaceholderString(new String[]{"sp", "spid", "subpart", "subpartid"}, null, new String[0]);
        this.remove = mythicLineConfig.getBoolean(new String[]{"r", "remove"}, false);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ActiveModel activeModel = MythicUtils.getActiveModelOrNull(modeledEntity, string);
        if (activeModel == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string2 = MythicUtils.getOrNull(this.parentId, (PlaceholderMeta)skillMetadata, abstractEntity);
        String string3 = MythicUtils.getOrNull(this.childId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (this.remove) {
            if (string3 == null) {
                return SkillResult.INVALID_CONFIG;
            }
            activeModel.removeBone(string3);
        } else {
            if (string2 == null || string3 == null) {
                return SkillResult.INVALID_CONFIG;
            }
            BlueprintBone blueprintBone = activeModel.getBlueprint().getFlatMap().get(string3);
            if (blueprintBone == null) {
                return SkillResult.INVALID_CONFIG;
            }
            activeModel.forceGenerateBone(string2, blueprintBone);
        }
        return SkillResult.SUCCESS;
    }
}

