/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderDouble;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicSwapEntity
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final boolean hitbox;
    private final boolean invisible;
    private final PlaceholderDouble stepHeight;
    private final PlaceholderInt viewRadius;

    public MechanicSwapEntity(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.hitbox = mythicLineConfig.getBoolean(new String[]{"h", "hitbox"}, true);
        this.invisible = mythicLineConfig.getBoolean(new String[]{"i", "invis", "invisible"}, true);
        this.stepHeight = mythicLineConfig.getPlaceholderDouble(new String[]{"s", "step"}, 0.5, new String[0]);
        this.viewRadius = mythicLineConfig.getPlaceholderInteger(new String[]{"rad", "radius"}, 0, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        AbstractEntity abstractEntity2 = skillMetadata.getCaster().getEntity();
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity2.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = this.modelId.get((PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null) {
            return SkillResult.INVALID_CONFIG;
        }
        if (modeledEntity.getModel(string) == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ModeledEntity modeledEntity2 = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity2 == null) {
            modeledEntity2 = ModelEngineAPI.createModeledEntity(abstractEntity.getBukkitEntity());
        } else if (modeledEntity2.getModel(string) != null) {
            return SkillResult.CONDITION_FAILED;
        }
        ActiveModel activeModel = modeledEntity.removeModel(string);
        activeModel.setSwappable(true);
        if (modeledEntity.getModels().isEmpty()) {
            modeledEntity.setBaseEntityVisible(true);
            ModelEngineAPI.removeModeledEntity(abstractEntity2.getUniqueId());
        }
        double d = this.stepHeight.get((PlaceholderMeta)skillMetadata, abstractEntity);
        int n = this.viewRadius.get((PlaceholderMeta)skillMetadata, abstractEntity);
        modeledEntity2.setBaseEntityVisible(!this.invisible);
        modeledEntity2.setStepHeight(d);
        if (n > 0) {
            modeledEntity2.getRangeManager().setRenderDistance(n);
        }
        modeledEntity2.addModel(activeModel, this.hitbox);
        return SkillResult.SUCCESS;
    }
}

