/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;

public class MechanicSwapModel
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString newModelId;

    public MechanicSwapModel(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.newModelId = mythicLineConfig.getPlaceholderString(new String[]{"n", "nid", "newmodel", "newmodelid"}, null, new String[0]);
        TLogger.warn("The SwapModel mechanic would be deprecated very soon. Please use the Model mechanic.");
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null || modeledEntity.getModel(string) == null) {
            return SkillResult.INVALID_CONFIG;
        }
        String string2 = MythicUtils.getOrNull(this.newModelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        ModelBlueprint modelBlueprint = MythicUtils.getBlueprintOrNull(string2);
        if (modelBlueprint == null) {
            return SkillResult.INVALID_CONFIG;
        }
        ActiveModel activeModel = modeledEntity.removeModel(string);
        ActiveModel activeModel2 = ModelEngineAPI.createActiveModel(modelBlueprint);
        activeModel2.setLockPitch(activeModel.isLockPitch());
        activeModel2.setLockYaw(activeModel.isLockYaw());
        activeModel2.setCanHurt(activeModel.isCanHurt());
        activeModel.destroy();
        modeledEntity.addModel(activeModel2, true);
        return SkillResult.SUCCESS;
    }
}

