/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Renderer;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;
import org.bukkit.Color;

public class MechanicTint
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString color;
    private final boolean damageTint;
    private final boolean exactMatch;

    public MechanicTint(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, "", new String[0]);
        this.color = mythicLineConfig.getPlaceholderString(new String[]{"c", "color"}, "FFFFFF", new String[0]);
        this.damageTint = mythicLineConfig.getBoolean(new String[]{"d", "dmg", "damage", "damagetint"}, false);
        this.exactMatch = mythicLineConfig.getBoolean(new String[]{"em", "exact", "match", "exactmatch"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(abstractEntity.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String string = MythicUtils.getOrNull(this.color, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        Color color = Color.fromRGB((int)Integer.parseInt(string, 16));
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        String string3 = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        MythicUtils.executeOptModelId(modeledEntity, string3, activeModel -> this.color((ActiveModel)activeModel, string2, color));
        return SkillResult.SUCCESS;
    }

    private void color(ActiveModel activeModel, String string, Color color) {
        Map map = activeModel.getRendererHandler().getBones();
        if (this.exactMatch) {
            if (map.containsKey(string)) {
                if (this.damageTint) {
                    ((Renderer)map.get(string)).setHurt(color);
                } else {
                    ((Renderer)map.get(string)).setWhite(color);
                }
            }
        } else {
            for (String string2 : map.keySet()) {
                if (!string2.contains(string)) continue;
                if (this.damageTint) {
                    ((Renderer)map.get(string2)).setHurt(color);
                    continue;
                }
                ((Renderer)map.get(string2)).setWhite(color);
            }
        }
    }
}

