/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.model;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.mythic.MythicUtils;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import org.bukkit.entity.Player;

public class MechanicUndisguise
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;

    public MechanicUndisguise(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        if (!abstractEntity.isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        Player player = (Player)abstractEntity.getBukkitEntity();
        ModeledEntity modeledEntity = ModelEngineAPI.getModeledEntity(player.getUniqueId());
        if (modeledEntity == null) {
            return SkillResult.INVALID_TARGET;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null) {
            modeledEntity.destroy();
            modeledEntity.setBaseEntityVisible(true);
            ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, false);
            ModelEngineAPI.removeModeledEntity(player.getUniqueId());
        } else {
            ActiveModel activeModel = modeledEntity.removeModel(string);
            if (activeModel == null) {
                return SkillResult.CONDITION_FAILED;
            }
            activeModel.destroy();
            if (modeledEntity.getModels().isEmpty()) {
                modeledEntity.setBaseEntityVisible(true);
                ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(player, false);
                ModelEngineAPI.removeModeledEntity(player.getUniqueId());
            }
        }
        return SkillResult.SUCCESS;
    }
}

