/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.mythic.mechanics.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.mythic.MythicUtils;
import com.ticxo.modelengine.mythic.compatibility.ProjectileEntity;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.ThreadSafetyLevel;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.UUID;
import org.bukkit.Color;

public class MechanicVFX
implements ITargetedEntitySkill,
INoTargetSkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final boolean remove;
    private final PlaceholderInt radius;
    private final PlaceholderString color;
    private final boolean enchant;
    private final boolean visible;
    private final boolean baseVisible;
    private final boolean autoTick;
    private final boolean autoRange;

    public MechanicVFX(MythicLineConfig mythicLineConfig) {
        this.modelId = mythicLineConfig.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mythicLineConfig.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, null, new String[0]);
        this.remove = mythicLineConfig.getBoolean(new String[]{"r", "remove"}, false);
        this.radius = mythicLineConfig.getPlaceholderInteger(new String[]{"rad", "radius"}, 0, new String[0]);
        this.color = mythicLineConfig.getPlaceholderString(new String[]{"c", "color"}, "FFFFFF", new String[0]);
        this.enchant = mythicLineConfig.getBoolean(new String[]{"en", "enchant"}, false);
        this.visible = mythicLineConfig.getBoolean(new String[]{"v", "visible"}, true);
        this.baseVisible = mythicLineConfig.getBoolean(new String[]{"bv", "bvisible"}, false);
        this.autoTick = mythicLineConfig.getBoolean(new String[]{"at", "autotick"}, false);
        this.autoRange = mythicLineConfig.getBoolean(new String[]{"ar", "autorange"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata skillMetadata, AbstractEntity abstractEntity) {
        if (this.remove) {
            VFX vFX = ModelEngineAPI.getVFXTicker().getVFX(abstractEntity.getUniqueId());
            if (vFX == null) {
                return SkillResult.CONDITION_FAILED;
            }
            vFX.destroy();
            return SkillResult.SUCCESS;
        }
        String string = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata, abstractEntity);
        String string2 = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata, abstractEntity);
        if (string == null || string2 == null) {
            return SkillResult.INVALID_CONFIG;
        }
        int n = this.radius.get((PlaceholderMeta)skillMetadata, abstractEntity);
        Color color = MythicUtils.getColor(MythicUtils.getOrNull(this.color, (PlaceholderMeta)skillMetadata, abstractEntity));
        VFX vFX = ModelEngineAPI.createVFX(abstractEntity.getBukkitEntity());
        vFX.useModel(string, string2);
        if (n > 0) {
            vFX.getRangeManager().setRenderDistance(n);
        }
        vFX.setColor(color);
        vFX.setEnchant(this.enchant);
        vFX.setAutoTick(this.autoTick);
        vFX.setVisible(this.visible);
        vFX.setBaseEntityVisible(this.baseVisible);
        vFX.create();
        return SkillResult.SUCCESS;
    }

    public SkillResult cast(SkillMetadata skillMetadata) {
        Object object = skillMetadata.getCallingEvent();
        if (!(object instanceof Projectile.ProjectileTracker)) {
            return SkillResult.INVALID_TARGET;
        }
        Projectile.ProjectileTracker projectileTracker = (Projectile.ProjectileTracker)object;
        if (this.remove) {
            object = MythicUtils.getVFXUniqueId(skillMetadata);
            VFX vFX = ModelEngineAPI.getVFXTicker().getVFX((UUID)object);
            if (vFX == null) {
                return SkillResult.CONDITION_FAILED;
            }
            vFX.destroy();
            return SkillResult.SUCCESS;
        }
        object = MythicUtils.getOrNull(this.modelId, (PlaceholderMeta)skillMetadata);
        String string = MythicUtils.getOrNull(this.partId, (PlaceholderMeta)skillMetadata);
        if (object == null || string == null) {
            return SkillResult.INVALID_CONFIG;
        }
        int n = this.radius.get((PlaceholderMeta)skillMetadata);
        Color color = MythicUtils.getColor(MythicUtils.getOrNull(this.color, (PlaceholderMeta)skillMetadata));
        ProjectileEntity projectileEntity = new ProjectileEntity(projectileTracker, this.autoRange);
        VFX vFX = ModelEngineAPI.createVFX(projectileEntity);
        vFX.useModel((String)object, string);
        if (n > 0) {
            vFX.getRangeManager().setRenderDistance(n);
        }
        vFX.setColor(color);
        vFX.setEnchant(this.enchant);
        vFX.setAutoTick(this.autoTick);
        vFX.setVisible(this.visible);
        vFX.setBaseEntityVisible(this.baseVisible);
        vFX.create();
        return SkillResult.SUCCESS;
    }

    public ThreadSafetyLevel getThreadSafetyLevel() {
        return this.autoRange ? ThreadSafetyLevel.SYNC_ONLY : ThreadSafetyLevel.EITHER;
    }
}

