/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.entity.controller;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.Mountable;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.nms.v1_16_R3.NMSFields;
import java.lang.reflect.Field;
import net.minecraft.server.v1_16_R3.ControllerMove;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MoveControlWrapper
extends ControllerMove
implements MoveController {
    private static final Field operationField = FieldUtils.getField(ControllerMove.class, NMSFields.MOVECONTROL_operation);
    protected final ModeledEntity modeledEntity;
    protected final MountManager mountManager;
    protected final ControllerMove original;
    protected ControllerMove.Operation operation;
    protected boolean isOnGround;

    public MoveControlWrapper(EntityInsentient entityInsentient, ControllerMove controllerMove, ModeledEntity modeledEntity) {
        super(entityInsentient);
        this.original = controllerMove;
        this.modeledEntity = modeledEntity;
        this.mountManager = modeledEntity.getMountManager();
        this.operation = ControllerMove.Operation.WAIT;
    }

    public boolean b() {
        return this.original.b();
    }

    public double c() {
        return this.original.c();
    }

    public void a(double d, double d2, double d3, double d4) {
        this.original.a(d, d2, d3, d4);
        if (this.operation != ControllerMove.Operation.JUMPING) {
            this.operation = ControllerMove.Operation.MOVE_TO;
        }
    }

    public void a(float f, float f2) {
        this.original.a(f, f2);
        this.operation = ControllerMove.Operation.STRAFE;
    }

    public void a() {
        this.isOnGround = this.a.isOnGround();
        if (this.mountManager != null && this.mountManager.isControlled()) {
            this.a.setOnGround(true);
            this.disableWaterJumping();
            this.controlledTick();
        } else {
            this.defaultTick();
        }
        if (this.mountManager != null) {
            this.passengerTick();
        }
    }

    protected void controlledTick() {
        this.a.t(0.0f);
        this.a.v(0.0f);
        MountController mountController = this.mountManager.getDriverController();
        if (mountController == null) {
            return;
        }
        if (mountController.getInput() == null) {
            mountController.setInput(new MountController.MountInput());
        }
        mountController.updateDriverMovement(this, this.modeledEntity);
        mountController.updateRiderPosition(this, this.mountManager.getDriverBone());
    }

    private void disableWaterJumping() {
        if (this.a.isInWater()) {
            try {
                FieldUtils.getField(EntityLiving.class, NMSFields.LIVING_ENTITY_noJumpDelay).setInt(this.a, 1);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    protected void defaultTick() {
        switch (this.operation) {
            case WAIT: {
                this.modeledEntity.setState(ModelState.IDLE);
                break;
            }
            case MOVE_TO: 
            case STRAFE: {
                this.modeledEntity.setState((double)this.a.dN() <= 1.0E-5 ? ModelState.IDLE : ModelState.WALK);
                break;
            }
            case JUMPING: {
                this.modeledEntity.setState(ModelState.JUMP);
            }
        }
        this.original.a();
        switch (this.operation) {
            case STRAFE: {
                this.operation = ControllerMove.Operation.WAIT;
                break;
            }
            case MOVE_TO: {
                try {
                    this.operation = (ControllerMove.Operation)operationField.get(this.original);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                break;
            }
            case JUMPING: {
                if (!this.a.isOnGround()) break;
                this.operation = ControllerMove.Operation.WAIT;
            }
        }
    }

    protected void passengerTick() {
        if (!this.mountManager.hasPassengers()) {
            return;
        }
        for (Entity entity : this.mountManager.getPassengers().keySet()) {
            Mountable mountable = this.mountManager.getPassengers().get(entity);
            MountController mountController = this.mountManager.getController(entity.getUniqueId());
            if (mountController == null) continue;
            if (mountController.getInput() == null) {
                mountController.setInput(new MountController.MountInput());
            }
            mountController.updatePassengerMovement(this, this.modeledEntity);
            mountController.updateRiderPosition(this, mountable);
        }
    }

    protected void setOperation(ControllerMove.Operation operation) {
        try {
            operationField.set(this.original, operation);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        this.operation = operation;
    }

    protected ControllerMove.Operation getOperation() {
        try {
            return (ControllerMove.Operation)operationField.get(this.original);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return ControllerMove.Operation.WAIT;
        }
    }

    public double d() {
        return this.original.d();
    }

    public double e() {
        return this.original.e();
    }

    public double f() {
        return this.original.f();
    }

    @Override
    public void move(float f, float f2, float f3) {
        float f4 = this.getSpeed();
        this.a.q(f4 * f3);
        this.a.t(f2);
        this.a.v(f);
    }

    @Override
    public void jump() {
        this.a.getControllerJump().jump();
    }

    @Override
    public void setVelocity(double d, double d2, double d3) {
        this.a.setMot(d, d2, d3);
    }

    @Override
    public void addVelocity(double d, double d2, double d3) {
        this.a.setMot(this.a.getMot().add(d, d2, d3));
    }

    @Override
    public void nullifyFallDistance() {
        this.a.fallDistance = 0.0f;
    }

    @Override
    public void movePassenger(Entity entity, double d, double d2, double d3) {
        net.minecraft.server.v1_16_R3.Entity entity2 = ((CraftEntity)entity).getHandle();
        double d4 = d2 + entity2.bb();
        entity2.setPosition(d, d4, d3);
        entity2.setMot(Vec3D.ORIGIN);
        this.a.fallDistance = 0.0f;
        net.minecraft.server.v1_16_R3.Entity entity3 = entity2;
        if (entity3 instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity3;
            try {
                FieldUtils.getField(PlayerConnection.class, NMSFields.SERVERGAMEPACKETLISTENERIMPL_clientIsFloating).setBoolean(entityPlayer.playerConnection, false);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    @Override
    public boolean isOnGround() {
        return this.isOnGround;
    }

    @Override
    public float getSpeed() {
        return (float)this.a.craftAttributes.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).getBaseValue();
    }

    @Override
    public Vector getVelocity() {
        return CraftVector.toBukkit((Vec3D)this.a.getMot());
    }
}

