/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.network.interact;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.ChatMessage;
import net.minecraft.server.v1_16_R3.CriterionTriggers;
import net.minecraft.server.v1_16_R3.Entity;
import net.minecraft.server.v1_16_R3.EntityArrow;
import net.minecraft.server.v1_16_R3.EntityExperienceOrb;
import net.minecraft.server.v1_16_R3.EntityFish;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityInsentient;
import net.minecraft.server.v1_16_R3.EntityItem;
import net.minecraft.server.v1_16_R3.EntityLiving;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.EnumHand;
import net.minecraft.server.v1_16_R3.EnumInteractionResult;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.Item;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.Items;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketListener;
import net.minecraft.server.v1_16_R3.PacketListenerPlayIn;
import net.minecraft.server.v1_16_R3.PacketPlayInUseEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutAttachEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import net.minecraft.server.v1_16_R3.PlayerConnectionUtils;
import net.minecraft.server.v1_16_R3.Vec3D;
import net.minecraft.server.v1_16_R3.World;
import net.minecraft.server.v1_16_R3.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class PatchedInteractHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void handleInteract(PacketPlayInUseEntity packetPlayInUseEntity, PacketListenerPlayIn packetListenerPlayIn) {
        Entity entity;
        int n;
        Entity entity2;
        PacketListenerPlayIn packetListenerPlayIn2 = packetListenerPlayIn;
        if (!(packetListenerPlayIn2 instanceof PlayerConnection)) {
            return;
        }
        PlayerConnection playerConnection = (PlayerConnection)packetListenerPlayIn2;
        PlayerConnectionUtils.ensureMainThread((Packet)packetPlayInUseEntity, (PacketListener)playerConnection, (WorldServer)playerConnection.player.getWorldServer());
        packetListenerPlayIn2 = playerConnection.player;
        if (packetListenerPlayIn2.isFrozen()) {
            return;
        }
        WorldServer worldServer = packetListenerPlayIn2.getWorldServer();
        if (worldServer == null) {
            return;
        }
        CraftPlayer craftPlayer = packetListenerPlayIn2.getBukkitEntity();
        CraftServer craftServer = worldServer.getServer();
        Entity entity3 = packetPlayInUseEntity.a((World)worldServer);
        if (entity3 == packetListenerPlayIn2 && !packetListenerPlayIn2.isSpectator()) {
            playerConnection.disconnect("Cannot interact with self!");
            return;
        }
        packetListenerPlayIn2.resetIdleTimer();
        packetListenerPlayIn2.setSneaking(packetPlayInUseEntity.e());
        if (entity3 == null) {
            return;
        }
        Entity entity4 = entity3;
        SubHitbox subHitbox = ModelEngineAPI.getModelTicker().getSubHitboxBone(entity3.getUniqueID());
        if (subHitbox != null && (entity2 = worldServer.getEntity(n = subHitbox.getSubHitboxEntity().getRelayed().getEntityId())) != null && entity2 != packetListenerPlayIn2) {
            entity4 = entity2;
        }
        if (!worldServer.getWorldBorder().a(entity4.getChunkCoordinates())) {
            return;
        }
        if (!PatchedInteractHandler.canInteract((EntityPlayer)packetListenerPlayIn2, entity3)) {
            return;
        }
        Entity entity5 = entity4;
        entity2 = packetPlayInUseEntity.c();
        ItemStack itemStack = entity2 != null ? packetListenerPlayIn2.b((EnumHand)entity2).cloneItemStack() : ItemStack.b;
        Optional<Object> optional = Optional.empty();
        ItemStack itemStack2 = packetListenerPlayIn2.b(packetPlayInUseEntity.c() == null ? EnumHand.MAIN_HAND : packetPlayInUseEntity.c());
        if (packetPlayInUseEntity.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT || packetPlayInUseEntity.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT_AT) {
            PlayerInteractEntityEvent playerInteractEntityEvent;
            boolean bl = itemStack2 != null && itemStack2.getItem() == Items.LEAD && entity5 instanceof EntityInsentient;
            Item item = entity = packetListenerPlayIn2.inventory.getItemInHand() == null ? null : packetListenerPlayIn2.inventory.getItemInHand().getItem();
            if (packetPlayInUseEntity.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT) {
                playerInteractEntityEvent = new PlayerInteractEntityEvent((Player)craftPlayer, (org.bukkit.entity.Entity)entity5.getBukkitEntity(), packetPlayInUseEntity.c() == EnumHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
            } else {
                Vec3D vec3D = packetPlayInUseEntity.d();
                playerInteractEntityEvent = new PlayerInteractAtEntityEvent((Player)craftPlayer, (org.bukkit.entity.Entity)entity5.getBukkitEntity(), new Vector(vec3D.x, vec3D.y, vec3D.z), packetPlayInUseEntity.c() == EnumHand.OFF_HAND ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
            }
            craftServer.getPluginManager().callEvent((Event)playerInteractEntityEvent);
            if (entity5 instanceof EntityFish && entity != null && entity.getItem() == Items.WATER_BUCKET && (playerInteractEntityEvent.isCancelled() || packetListenerPlayIn2.inventory.getItemInHand() == null || packetListenerPlayIn2.inventory.getItemInHand().getItem() != entity)) {
                playerConnection.sendPacket((Packet)new PacketPlayOutSpawnEntityLiving((EntityLiving)((EntityFish)entity5)));
                packetListenerPlayIn2.updateInventory(packetListenerPlayIn2.activeContainer);
            }
            if (bl && (playerInteractEntityEvent.isCancelled() || packetListenerPlayIn2.inventory.getItemInHand() == null || packetListenerPlayIn2.inventory.getItemInHand().getItem() != entity)) {
                playerConnection.sendPacket((Packet)new PacketPlayOutAttachEntity(entity5, ((EntityInsentient)entity5).getLeashHolder()));
            }
            if (playerInteractEntityEvent.isCancelled() || packetListenerPlayIn2.inventory.getItemInHand() == null || packetListenerPlayIn2.inventory.getItemInHand().getItem() != entity) {
                playerConnection.sendPacket((Packet)new PacketPlayOutEntityMetadata(entity5.getId(), entity5.getDataWatcher(), true));
            }
            if (playerInteractEntityEvent.isCancelled()) {
                return;
            }
        }
        if (packetPlayInUseEntity.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT) {
            entity = entity5;
            if (entity instanceof SubHitboxEntity) {
                SubHitboxEntity subHitboxEntity = (SubHitboxEntity)entity;
                subHitboxEntity.onFakeInteract((Player)craftPlayer, entity2 == EnumHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                return;
            }
            entity = entity3;
            if (entity instanceof SubHitboxEntity) {
                SubHitboxEntity subHitboxEntity = (SubHitboxEntity)entity;
                subHitboxEntity.onRealInteract((Player)craftPlayer, entity2 == EnumHand.MAIN_HAND ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
            }
            optional = Optional.of(packetListenerPlayIn2.a(entity3, (EnumHand)entity2));
            if (itemStack2 != null && !itemStack2.isEmpty() && itemStack2.getCount() <= -1) {
                packetListenerPlayIn2.updateInventory(packetListenerPlayIn2.activeContainer);
            }
        } else if (packetPlayInUseEntity.b() == PacketPlayInUseEntity.EnumEntityUseAction.INTERACT_AT) {
            if (entity5 instanceof SubHitboxEntity) {
                return;
            }
            optional = Optional.of(entity5.a((EntityHuman)packetListenerPlayIn2, packetPlayInUseEntity.d(), (EnumHand)entity2));
            if (itemStack2 != null && !itemStack2.isEmpty() && itemStack2.getCount() <= -1) {
                packetListenerPlayIn2.updateInventory(packetListenerPlayIn2.activeContainer);
            }
        } else if (packetPlayInUseEntity.b() == PacketPlayInUseEntity.EnumEntityUseAction.ATTACK) {
            if (entity3 instanceof EntityItem || entity3 instanceof EntityExperienceOrb || entity3 instanceof EntityArrow || entity3 == packetListenerPlayIn2 && !packetListenerPlayIn2.isSpectator()) {
                playerConnection.disconnect((IChatBaseComponent)new ChatMessage("multiplayer.disconnect.invalid_entity_attacked"));
                LOGGER.warn("Player {} tried to attack an invalid entity", (Object)packetListenerPlayIn2.getDisplayName().getString());
                return;
            }
            packetListenerPlayIn2.attack(entity3);
            if (itemStack2 != null && !itemStack2.isEmpty() && itemStack2.getCount() <= -1) {
                packetListenerPlayIn2.updateInventory(packetListenerPlayIn2.activeContainer);
            }
        }
        if (optional.isPresent() && ((EnumInteractionResult)optional.get()).a()) {
            CriterionTriggers.P.a((EntityPlayer)packetListenerPlayIn2, itemStack, entity5);
            if (((EnumInteractionResult)optional.get()).b()) {
                packetListenerPlayIn2.swingHand((EnumHand)entity2, true);
            }
        }
    }

    private static boolean canInteract(EntityPlayer entityPlayer, Entity entity) {
        AxisAlignedBB axisAlignedBB = entity.getBoundingBox();
        Vec3D vec3D = entityPlayer.j(1.0f).d(axisAlignedBB.f());
        Vector vector = new Vector(Math.max(Math.abs(vec3D.x) - axisAlignedBB.b() / 2.0, 0.0), Math.max(Math.abs(vec3D.y) - axisAlignedBB.c() / 2.0, 0.0), Math.max(Math.abs(vec3D.z) - axisAlignedBB.d() / 2.0, 0.0));
        return vector.lengthSquared() < 36.0;
    }

    private static boolean canInteractDir(EntityPlayer entityPlayer, Entity entity) {
        AxisAlignedBB axisAlignedBB = entity.getBoundingBox();
        return TMath.isBoundingBoxWithinDistance(new Vector(entityPlayer.locX(), entityPlayer.getHeadY(), entityPlayer.locZ()), PatchedInteractHandler.getDirection(entityPlayer), new BoundingBox(axisAlignedBB.minX, axisAlignedBB.minY, axisAlignedBB.minZ, axisAlignedBB.maxX, axisAlignedBB.maxY, axisAlignedBB.maxZ), 6.0);
    }

    private static Vector getDirection(EntityPlayer entityPlayer) {
        Vector vector = new Vector();
        double d = entityPlayer.getHeadRotation();
        double d2 = entityPlayer.pitch;
        vector.setY(-Math.sin(Math.toRadians(d2)));
        double d3 = Math.cos(Math.toRadians(d2));
        vector.setX(-d3 * Math.sin(Math.toRadians(d)));
        vector.setZ(d3 * Math.cos(Math.toRadians(d)));
        return vector;
    }
}

