/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_16_R3.world.phys;

import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.Quaternion;
import java.util.Optional;
import net.minecraft.server.v1_16_R3.AxisAlignedBB;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class OBB
extends AxisAlignedBB {
    private final EulerAngle rotation;
    private final float yaw;
    private final OrientedBoundingBox bukkitOBB;

    public OBB(double d, double d2, double d3, EulerAngle eulerAngle, float f) {
        this(-d * 0.5, -d2 * 0.5, -d3 * 0.5, d * 0.5, d2 * 0.5, d3 * 0.5, eulerAngle, f);
    }

    public OBB(Vec3D vec3D, Vec3D vec3D2, EulerAngle eulerAngle, float f) {
        this(vec3D.x, vec3D.y, vec3D.z, vec3D2.x, vec3D2.y, vec3D2.z, eulerAngle, f);
    }

    public OBB(double d, double d2, double d3, double d4, double d5, double d6, EulerAngle eulerAngle, float f) {
        super(d, d2, d3, d4, d5, d6);
        this.rotation = eulerAngle;
        this.yaw = f;
        this.bukkitOBB = new OrientedBoundingBox(CraftVector.toBukkit((Vec3D)this.f()), new Vector(this.b(), this.c(), this.d()), eulerAngle, f);
    }

    public OBB makeOBBInstance(Vec3D vec3D, EulerAngle eulerAngle, float f) {
        return new OBB(vec3D.add(this.minX, this.minY, this.minZ), vec3D.add(this.maxX, this.maxY, this.maxZ), eulerAngle, f);
    }

    public AxisAlignedBB d(double d, double d2, double d3) {
        double d4 = this.minX - d;
        double d5 = this.minY - d2;
        double d6 = this.minZ - d3;
        double d7 = this.maxX + d;
        double d8 = this.maxY + d2;
        double d9 = this.maxZ + d3;
        return new OBB(d4, d5, d6, d7, d8, d9, this.rotation, this.yaw);
    }

    public boolean c(AxisAlignedBB axisAlignedBB) {
        boolean bl;
        AxisAlignedBB axisAlignedBB2 = axisAlignedBB;
        if (axisAlignedBB2 instanceof OBB) {
            OBB oBB = (OBB)axisAlignedBB2;
            bl = this.intersects(oBB);
        } else {
            bl = super.c(axisAlignedBB);
        }
        return bl;
    }

    public boolean intersects(OBB oBB) {
        return this.bukkitOBB.intersects(oBB.bukkitOBB);
    }

    public boolean a(double d, double d2, double d3, double d4, double d5, double d6) {
        OrientedBoundingBox orientedBoundingBox = new OrientedBoundingBox(d, d2, d3, d4, d5, d6);
        return this.bukkitOBB.intersects(orientedBoundingBox);
    }

    public Optional<Vec3D> b(Vec3D vec3D, Vec3D vec3D2) {
        EulerAngle eulerAngle = Quaternion.fromEulerAngle(this.rotation).conjugate().toEulerAngle();
        Vector vector = CraftVector.toBukkit((Vec3D)this.f());
        Vector vector2 = CraftVector.toBukkit((Vec3D)vec3D);
        Vector vector3 = CraftVector.toBukkit((Vec3D)vec3D2);
        Offset.getRelativeLocation(eulerAngle, vector2.subtract(vector)).add(vector);
        Offset.getRelativeLocation(eulerAngle, vector3.subtract(vector)).add(vector);
        Optional optional = super.b(CraftVector.toNMS((Vector)vector2), CraftVector.toNMS((Vector)vector3));
        if (optional.isEmpty()) {
            return optional;
        }
        Vector vector4 = CraftVector.toBukkit((Vec3D)((Vec3D)optional.get()));
        Offset.getRelativeLocation(this.rotation, vector4.subtract(vector)).add(vector);
        return Optional.of(CraftVector.toNMS((Vector)vector4));
    }

    public String toString() {
        return "OBB(rotation=" + this.rotation + ", yaw=" + this.yaw + ", bukkitOBB=" + this.getBukkitOBB() + ")";
    }

    public OrientedBoundingBox getBukkitOBB() {
        return this.bukkitOBB;
    }
}

