/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.Renderer;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_18_R2.PacketDataFixer;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.EulerAngle;

public class BoneRendererImplB
implements BoneRenderer {
    private static final ItemStack empty = new ItemStack(Material.AIR);
    private ModelBone bone;
    private Renderer rendererBone;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final FakeAreaEffectCloud cloud;
    private final FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private int data = -1;
    private Color color = Color.WHITE;
    private boolean isEnchant;
    private boolean isModelVisible = true;
    private boolean isInitialized = false;

    public BoneRendererImplB(ModelBone modelBone) {
        this.setBone(modelBone);
        boolean bl = !modelBone.getBlueprintBone().check("large");
        this.cloud = new FakeAreaEffectCloud(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.cloud.setSmall(bl);
        this.cloud.setDisplay(FakeEntity.DisplaySlot.HEAD);
        this.armorStand = new FakeArmorStand(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(bl);
        this.armorStand.setDisplay(FakeEntity.DisplaySlot.HEAD);
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.rendererBone = modelBone instanceof Renderer ? (Renderer)modelBone : null;
        this.rangeManager = modelBone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.cloud.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        if (this.rendererBone.isGhost()) {
            this.item = empty;
            return;
        }
        this.item = ModelEngineAPI.api.getGenerator().getBaseItemType().create();
        int n = this.data;
        if (this.data == -1) {
            n = this.bone.getActiveModel().getBlueprint().getItemIds().get(this.bone.getBoneId());
        }
        this.setData(n);
        Color color = this.color;
        this.color = null;
        this.setColor(color);
        this.isItemDirty = false;
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty)}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.sendProtocolDependant(player, packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty)}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.getLocation().zero().add(this.bone.getPosition());
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.cloud.updatePosition(this.bone.getPosition());
        PacketPlayOutEntity.PacketPlayOutEntityLook packetPlayOutEntityLook = this.armorStand.updateYaw(this.bone.getYaw(), false);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = null;
        if (this.isItemDirty) {
            packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
            this.isItemDirty = false;
        }
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutEntityTeleport, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_UPDATE});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityLook, packetPlayOutEntityMetadata, packetPlayOutEntityEquipment});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityEquipment});
    }

    @Override
    public void setSmall(boolean bl) {
        this.armorStand.setSmall(bl);
        this.cloud.setSmall(bl);
    }

    @Override
    public void setModel(ItemStack itemStack) {
        this.item = itemStack;
        this.isItemDirty = true;
    }

    @Override
    public void setModelVisible(boolean bl) {
        this.isModelVisible = bl;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean bl) {
        this.armorStand.setGlowing(bl);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(false);
        if (packetPlayOutEntityMetadata == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata});
    }

    @Override
    public void setColor(Color color) {
        if (color.equals((Object)this.color)) {
            return;
        }
        this.color = color;
        if (this.isGhost()) {
            return;
        }
        BaseItemEnum baseItemEnum = ModelEngineAPI.api.getGenerator().getBaseItemType();
        ItemMeta itemMeta = this.item.getItemMeta();
        baseItemEnum.color(itemMeta, color);
        this.item.setItemMeta(itemMeta);
        this.isItemDirty = true;
    }

    @Override
    public void setEnchant(boolean bl) {
        if (this.isEnchant == bl) {
            return;
        }
        this.isEnchant = bl;
        if (this.isGhost()) {
            return;
        }
        if (bl) {
            this.item.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            this.item.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
        this.isItemDirty = true;
    }

    @Override
    public void setData(int n) {
        ItemMeta itemMeta;
        if (this.data == n) {
            return;
        }
        this.data = n;
        if (this.isGhost()) {
            this.reconstructGhostModel();
        }
        if ((itemMeta = this.item.getItemMeta()) == null) {
            return;
        }
        itemMeta.setCustomModelData(Integer.valueOf(n));
        this.item.setItemMeta(itemMeta);
        this.isItemDirty = true;
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.bone.getActiveModel().getModeledEntity().getBase().getWorld(), this.isModelVisible ? this.item : empty);
    }

    @Override
    public UUID getRendererUUID() {
        return this.armorStand.getUuid();
    }

    private EulerAngle getBoneRotation() {
        EulerAngle eulerAngle = this.bone.getClientAproxRotation();
        if (eulerAngle != null) {
            return eulerAngle;
        }
        return this.bone.getRotation();
    }

    private boolean isGhost() {
        return this.rendererBone.isGhost() && this.item.getType() == Material.AIR;
    }

    private void reconstructGhostModel() {
        this.item = ModelEngineAPI.api.getGenerator().getBaseItemType().create();
        BaseItemEnum baseItemEnum = ModelEngineAPI.api.getGenerator().getBaseItemType();
        ItemMeta itemMeta = this.item.getItemMeta();
        baseItemEnum.color(itemMeta, this.color);
        this.item.setItemMeta(itemMeta);
        if (this.isEnchant) {
            this.item.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            this.item.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

