/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_19_0_R1.network.NetworkUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.util.Vector;

public class FakeAreaEffectCloud {
    private final int entityId;
    private final UUID uuid;
    private final Vector location = new Vector();
    private byte lastYaw;
    private Vector lastOffset;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final DataWatcher.Item<Float> cloudRadius;
    private FakeEntity.DisplaySlot display = FakeEntity.DisplaySlot.ZERO;
    private boolean isSmall;

    public FakeAreaEffectCloud(double d, double d2, double d3) {
        this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.location.setX(d).setY(d2).setZ(d3);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)32);
        this.cloudRadius = new DataWatcher.Item(DataAccessors.CLOUD_RADIUS, (Object)Float.valueOf(0.0f));
    }

    public void setLocation(double d, double d2, double d3) {
        this.location.setX(d).setY(d2).setZ(d3);
    }

    public PacketPlayOutSpawnEntity spawn() {
        return this.spawn(0.0f);
    }

    public PacketPlayOutSpawnEntity spawn(float f) {
        this.updateOffset(TMath.rotToByte(f));
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.a(this.uuid);
        packetDataSerializer.d(IRegistry.X.a((Object)EntityTypes.c));
        packetDataSerializer.writeDouble(this.location.getX() + this.lastOffset.getX());
        packetDataSerializer.writeDouble(this.location.getY() + this.lastOffset.getY() + -0.375);
        packetDataSerializer.writeDouble(this.location.getZ() + this.lastOffset.getZ());
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeInt(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        packetDataSerializer.writeShort(0);
        return new PacketPlayOutSpawnEntity(packetDataSerializer);
    }

    public PacketPlayOutEntityMetadata meta() {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        DataWatcher.a(List.of(this.commonDataItem, this.cloudRadius), (PacketDataSerializer)packetDataSerializer);
        return new PacketPlayOutEntityMetadata(packetDataSerializer);
    }

    public PacketPlayOutEntityTeleport updatePosition(Vector vector) {
        return this.updatePosition(0.0f, vector);
    }

    public PacketPlayOutEntityTeleport updatePosition(float f, Vector vector) {
        byte by = TMath.rotToByte(f);
        if (TMath.isSimilar(this.location, vector) && this.lastYaw == by) {
            return null;
        }
        this.updateOffset(by);
        this.location.zero().add(vector);
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.writeDouble(this.location.getX() + this.lastOffset.getX());
        packetDataSerializer.writeDouble(this.location.getY() + this.lastOffset.getY() + -0.375);
        packetDataSerializer.writeDouble(this.location.getZ() + this.lastOffset.getZ());
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeByte(0);
        packetDataSerializer.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(packetDataSerializer);
    }

    public PacketPlayOutMount addPassengers(int ... nArray) {
        PacketDataSerializer packetDataSerializer = NetworkUtils.createByteBuf();
        packetDataSerializer.d(this.entityId);
        packetDataSerializer.a(nArray);
        return new PacketPlayOutMount(packetDataSerializer);
    }

    private void updateOffset(byte by) {
        if (this.lastYaw == by && this.lastOffset != null) {
            return;
        }
        this.lastYaw = by;
        this.lastOffset = this.display.getPivotOffset(this.isSmall, TMath.byteToRot(by));
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector getLocation() {
        return this.location;
    }

    public FakeEntity.DisplaySlot getDisplay() {
        return this.display;
    }

    public void setDisplay(FakeEntity.DisplaySlot displaySlot) {
        this.display = displaySlot;
    }

    public boolean isSmall() {
        return this.isSmall;
    }

    public void setSmall(boolean bl) {
        this.isSmall = bl;
    }
}

