/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R2.entity.fake.bone;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_20_R2.PacketDataFixer;
import com.ticxo.modelengine.nms.v1_20_R2.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_20_R2.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_20_R2.network.NetworkUtils;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class MountPointImplB
implements MountPoint {
    private final Set<Entity> passengers = Sets.newConcurrentHashSet();
    private ModelBone bone;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final FakeAreaEffectCloud cloud;
    private final FakeArmorStand armorStand;
    private boolean isInitialized = false;

    public MountPointImplB(ModelBone modelBone) {
        this.setBone(modelBone);
        this.cloud = new FakeAreaEffectCloud(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.armorStand = new FakeArmorStand(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.armorStand.setInvisible(true);
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.rangeManager = modelBone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.cloud.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        PacketPlayOutMount packetPlayOutMount2 = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount, packetPlayOutMount2});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.cloud.spawn();
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.cloud.meta();
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity2 = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata2 = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.cloud.addPassengers(this.armorStand.getEntityId());
        PacketPlayOutMount packetPlayOutMount2 = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.sendProtocolDependant(player, packetPlayOutSpawnEntity, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_SPAWN});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityMetadata, packetPlayOutSpawnEntity2, packetPlayOutEntityMetadata2, packetPlayOutMount, packetPlayOutMount2});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Vector vector = this.bone.getPosition();
        this.armorStand.getLocation().zero().add(vector);
        PacketPlayOutEntityTeleport packetPlayOutEntityTeleport = this.cloud.updatePosition(vector);
        PacketPlayOutEntity.PacketPlayOutEntityLook packetPlayOutEntityLook = this.armorStand.updateYaw(this.bone.getYaw(), false);
        NetworkUtils.sendProtocolDependant(this.rangeManager.getPlayerInRange(), packetPlayOutEntityTeleport, new PacketDataFixer[]{PacketDataFixer.CLOUD_RIDE_OFFSET_UPDATE});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityLook});
    }

    @Override
    public void addPassengers(Entity ... entityArray) {
        this.passengers.addAll(Arrays.asList(entityArray));
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutMount});
    }

    @Override
    public void removePassengers(Entity ... entityArray) {
        Arrays.asList(entityArray).forEach(this.passengers::remove);
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutMount});
    }

    @Override
    public void clearPassengers() {
        this.passengers.clear();
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutMount});
    }

    @Override
    public Set<Entity> getPassengers() {
        return ImmutableSet.copyOf(this.passengers);
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

