/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_20_R3.entity.fake.bone;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_20_R3.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_20_R3.network.NetworkUtils;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MountPointImplAC
implements MountPoint {
    private final Set<Entity> passengers = Sets.newConcurrentHashSet();
    private ModelBone bone;
    private RangeManager rangeManager = RangeManager.EMPTY;
    private final FakeArmorStand armorStand;
    private boolean isInitialized = false;
    private final boolean isC;

    public MountPointImplAC(ModelBone modelBone, boolean bl) {
        this.setBone(modelBone);
        this.isC = bl;
        this.armorStand = new FakeArmorStand(modelBone.getPosition().getX(), modelBone.getPosition().getY(), modelBone.getPosition().getZ());
        this.armorStand.setInvisible(true);
    }

    @Override
    public void setBone(ModelBone modelBone) {
        this.bone = modelBone;
        this.rangeManager = modelBone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.armorStand.setLocation(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutSpawnEntity, packetPlayOutEntityMetadata, packetPlayOutMount});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity packetPlayOutSpawnEntity = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = this.armorStand.updateMeta(true);
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(player, new Packet[]{packetPlayOutSpawnEntity, packetPlayOutEntityMetadata, packetPlayOutMount});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{packetPlayOutEntityDestroy});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Packet<PacketListenerPlayOut> packet = this.isC ? this.armorStand.updatePositionCalibrated(this.bone.getYaw(), this.bone.getPosition()) : this.armorStand.updatePosition(this.bone.getYaw(), this.bone.getPosition());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), packet);
    }

    @Override
    public void addPassengers(Entity ... entityArray) {
        this.passengers.addAll(Arrays.asList(entityArray));
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutMount});
    }

    @Override
    public void removePassengers(Entity ... entityArray) {
        Arrays.asList(entityArray).forEach(this.passengers::remove);
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutMount});
    }

    @Override
    public void clearPassengers() {
        this.passengers.clear();
        PacketPlayOutMount packetPlayOutMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packetPlayOutMount});
    }

    @Override
    public Set<Entity> getPassengers() {
        return ImmutableSet.copyOf(this.passengers);
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

