/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.nms.entity.fake.VFXRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class VFXImpl
implements VFX {
    private final BaseEntity<?> base;
    private final RangeManager rangeManager;
    private final VFXRenderer renderer;
    private boolean isSmall;
    private int data;
    private Color color;
    private boolean isEnchant;
    private boolean isVisible = true;
    private Vector position;
    private EulerAngle targetRotation = EulerAngle.ZERO;
    private EulerAngle rotation = EulerAngle.ZERO;
    private float yaw;
    private boolean isAutoTick;
    private boolean isBaseEntityVisible = true;
    private boolean isInitialized = false;
    private boolean isAlive = true;

    public VFXImpl(BaseEntity<?> baseEntity) {
        this.base = baseEntity;
        this.position = baseEntity.getLocation().toVector();
        this.rangeManager = baseEntity.wrapRangeManager(this);
        this.renderer = ModelEngineAPI.getEntityHandler().createVFXRenderer(this);
    }

    @Override
    public boolean tick() {
        if (!this.isInitialized) {
            return this.isAlive;
        }
        if (this.isAutoTick) {
            this.locationUpdate();
            this.update();
        }
        return !this.base.isDead() && this.isAlive;
    }

    @Override
    public void create() {
        this.locationUpdate();
        this.renderer.initialize();
        this.renderer.spawn();
        ModelEngineAPI.getVFXTicker().registerVFX(this.base, this);
        this.isInitialized = true;
    }

    @Override
    public void update() {
        this.renderer.update();
    }

    @Override
    public void destroy() {
        this.renderer.despawn();
        this.isAlive = false;
    }

    @Override
    public void useModel(String string, String string2) {
        ModelBlueprint modelBlueprint = ModelEngineAPI.getBlueprint(string);
        if (modelBlueprint == null) {
            return;
        }
        BlueprintBone blueprintBone = modelBlueprint.getFlatMap().get(string2);
        if (blueprintBone == null) {
            return;
        }
        Integer n = modelBlueprint.getItemIds().get(string2);
        if (n == null) {
            return;
        }
        this.setData(n);
        this.setSmall(!blueprintBone.check("large"));
    }

    @Override
    public void setSmall(boolean bl) {
        this.isSmall = bl;
        if (this.isInitialized) {
            this.renderer.setSmall(bl);
        }
    }

    @Override
    public void setData(int n) {
        this.data = n;
        if (this.isInitialized) {
            this.renderer.setData(n);
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.isInitialized) {
            this.renderer.setColor(color);
        }
    }

    @Override
    public void setEnchant(boolean bl) {
        this.isEnchant = bl;
        if (this.isInitialized) {
            this.renderer.setEnchant(bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
        if (this.isInitialized) {
            this.renderer.setModelVisible(bl);
        }
    }

    @Override
    public void rotate(EulerAngle eulerAngle, boolean bl) {
        this.setRotation(bl ? TMath.localRotate(this.rotation, eulerAngle) : TMath.globalRotate(this.rotation, eulerAngle));
    }

    @Override
    public void point(Vector vector, boolean bl) {
        double d = vector.getX() - this.position.getX();
        double d2 = vector.getY() - this.position.getY();
        double d3 = vector.getZ() - this.position.getZ();
        double d4 = TMath.fastSqrt(d * d + d3 * d3);
        float f = (float)(-TMath.fastAtan2(d2, d4));
        float f2 = (float)Math.toDegrees(TMath.fastAtan2(-d, d3));
        this.targetRotation = new EulerAngle((double)f, 0.0, 0.0);
        this.setYaw(f2);
        if (bl) {
            this.setRotation(EulerAngle.ZERO);
        }
    }

    @Override
    public EulerAngle getRotation() {
        return TMath.localRotate(this.targetRotation, this.rotation);
    }

    @Override
    public void setBaseEntityVisible(boolean bl) {
        if (this.isBaseEntityVisible == bl) {
            return;
        }
        this.isBaseEntityVisible = bl;
        if (bl) {
            this.base.broadcastSpawnPacket();
        } else {
            this.base.broadcastDespawnPacket();
        }
    }

    @Override
    public void showToPlayer(Player player) {
        this.renderer.spawn(player);
    }

    @Override
    public void hideFromPlayer(Player player) {
        this.renderer.despawn(player);
    }

    protected void locationUpdate() {
        this.position = this.base.getLocation().toVector();
        this.targetRotation = TMath.makeAngle(this.base.getXHeadRot(), 0.0, 0.0);
        this.yaw = this.base.getYHeadRot();
    }

    @Override
    public BaseEntity<?> getBase() {
        return this.base;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public VFXRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean isSmall() {
        return this.isSmall;
    }

    @Override
    public int getData() {
        return this.data;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isEnchant() {
        return this.isEnchant;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Vector getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector vector) {
        this.position = vector;
    }

    @Override
    public void setRotation(EulerAngle eulerAngle) {
        this.rotation = eulerAngle;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public void setYaw(float f) {
        this.yaw = f;
    }

    @Override
    public boolean isAutoTick() {
        return this.isAutoTick;
    }

    @Override
    public void setAutoTick(boolean bl) {
        this.isAutoTick = bl;
    }

    @Override
    public boolean isBaseEntityVisible() {
        return this.isBaseEntityVisible;
    }
}

