/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.animation;

import com.ticxo.modelengine.api.animation.Timeline;
import com.ticxo.modelengine.api.animation.interpolator.KeyframeInterpolator;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeType;
import com.ticxo.modelengine.api.animation.keyframe.KeyframeTypes;
import com.ticxo.modelengine.api.animation.keyframe.type.AbstractKeyframe;
import com.ticxo.modelengine.api.animation.keyframe.type.ScriptKeyframe;
import com.ticxo.modelengine.api.animation.property.IAnimationProperty;
import com.ticxo.modelengine.api.generator.blueprint.ModelBlueprint;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlueprintAnimation {
    private final ModelBlueprint modelBlueprint;
    private final Map<String, Timeline> timelines = new HashMap<String, Timeline>();
    private final String name;
    private final Timeline globalTimeline = new Timeline(this, false);
    private double length;
    private LoopMode loopMode;
    private boolean override;

    public Vector3f getPosition(String bone, IAnimationProperty property) {
        Timeline timeline = this.timelines.get(bone);
        if (timeline == null) {
            return null;
        }
        return timeline.getInterpolator(KeyframeTypes.POSITION).interpolate(property);
    }

    public Vector3f getRotation(String bone, IAnimationProperty property) {
        Timeline timeline = this.timelines.get(bone);
        if (timeline == null) {
            return null;
        }
        return timeline.getInterpolator(KeyframeTypes.ROTATION).interpolate(property);
    }

    public Vector3f getScale(String bone, IAnimationProperty property) {
        Timeline timeline = this.timelines.get(bone);
        if (timeline == null) {
            return null;
        }
        return timeline.getInterpolator(KeyframeTypes.SCALE).interpolate(property);
    }

    public List<ScriptKeyframe.Script> getScript(IAnimationProperty property) {
        return this.globalTimeline.getInterpolator(KeyframeTypes.SCRIPT).interpolate(property);
    }

    public String getInterpolation(KeyframeType<?, ?> type, String bone, float time) {
        Timeline timeline = this.timelines.get(bone);
        if (timeline == null) {
            return null;
        }
        KeyframeInterpolator<?, ?> interpolator = timeline.getInterpolator(type);
        AbstractKeyframe frame = (AbstractKeyframe)interpolator.get(Float.valueOf(time));
        if (frame != null) {
            return frame.getInterpolation();
        }
        frame = (AbstractKeyframe)interpolator.get(Float.valueOf(interpolator.getLowerKey(time)));
        if (frame == null) {
            return null;
        }
        return frame.getInterpolation();
    }

    public ModelBlueprint getModelBlueprint() {
        return this.modelBlueprint;
    }

    public Map<String, Timeline> getTimelines() {
        return this.timelines;
    }

    public String getName() {
        return this.name;
    }

    public Timeline getGlobalTimeline() {
        return this.globalTimeline;
    }

    public double getLength() {
        return this.length;
    }

    public LoopMode getLoopMode() {
        return this.loopMode;
    }

    public boolean isOverride() {
        return this.override;
    }

    public BlueprintAnimation(ModelBlueprint modelBlueprint, String name) {
        this.modelBlueprint = modelBlueprint;
        this.name = name;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public void setLoopMode(LoopMode loopMode) {
        this.loopMode = loopMode;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public static enum LoopMode {
        ONCE,
        HOLD,
        LOOP;


        public static LoopMode get(String mode) {
            try {
                return LoopMode.valueOf(mode.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return ONCE;
            }
        }

        @Nullable
        public static LoopMode getOrNull(String mode) {
            if (mode == null) {
                return null;
            }
            try {
                return LoopMode.valueOf(mode.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }
}

