/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.data.DummyEntityData;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.impl.DefaultBodyRotationController;
import com.ticxo.modelengine.api.nms.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.impl.EmptyMoveController;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;

public class Dummy<T>
implements BaseEntity<T> {
    protected final int entityId;
    protected final UUID uuid;
    protected final T original;
    protected final DummyEntityData<T> data;
    protected final BodyRotationController bodyRotationController;
    protected final MoveController moveController;
    protected final LookController lookController;
    protected boolean detectingPlayers = true;
    protected boolean isRemoved;
    protected boolean isWalking;
    protected boolean isStrafing;
    protected boolean isJumping;
    protected boolean isFlying;
    protected float yHeadRot;
    protected float xHeadRot;
    protected float yBodyRot;

    public Dummy() {
        this(null);
    }

    public Dummy(T original) {
        this(UUID.randomUUID(), original);
    }

    public Dummy(UUID uuid, T original) {
        this(ModelEngineAPI.getEntityHandler().getNextEntityId(), uuid, original);
    }

    public Dummy(int id, UUID uuid, T original) {
        this.entityId = id;
        this.uuid = uuid;
        this.original = original;
        this.data = new DummyEntityData(this);
        this.bodyRotationController = new DefaultBodyRotationController(this);
        this.moveController = new EmptyMoveController();
        this.lookController = new EmptyLookController();
    }

    @Override
    public boolean isAlive() {
        return !this.isRemoved;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public int getRenderRadius() {
        return this.data.getRenderRadius();
    }

    @Override
    public void setRenderRadius(int radius) {
        this.data.setRenderRadius(radius);
    }

    @Override
    public float getYRot() {
        return this.yHeadRot;
    }

    public void setLocation(Location location) {
        this.data.setLocation(location);
    }

    public void syncLocation(Location location) {
        this.data.setLocation(location);
        this.setYBodyRot(location.getYaw());
        this.setYHeadRot(location.getYaw());
        this.setXHeadRot(location.getPitch());
    }

    public void setForceViewing(Player player, boolean flag) {
        if (flag) {
            this.setForceHidden(player, false);
            this.data.getTracked().addForcedPairing(player);
        } else {
            this.data.getTracked().removeForcedPairing(player);
        }
    }

    public void setForceHidden(Player player, boolean flag) {
        if (flag) {
            this.setForceViewing(player, false);
            this.data.getTracked().addForcedHidden(player);
        } else {
            this.data.getTracked().removeForcedHidden(player);
        }
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean flag) {
    }

    @Override
    public boolean isForcedAlive() {
        return false;
    }

    @Override
    public void setForcedAlive(boolean flag) {
    }

    @Override
    public double getMaxStepHeight() {
        return 0.0;
    }

    @Override
    public void setMaxStepHeight(double stepHeight) {
    }

    @Override
    public void setCollidableWith(Entity entity, boolean flag) {
    }

    @Override
    public boolean hurt(@Nullable HumanEntity player, Object nmsDamageCause, float damage) {
        return false;
    }

    @Override
    public EntityHandler.InteractionResult interact(HumanEntity player, EquipmentSlot slot) {
        return null;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public T getOriginal() {
        return this.original;
    }

    @Override
    public DummyEntityData<T> getData() {
        return this.data;
    }

    @Override
    public BodyRotationController getBodyRotationController() {
        return this.bodyRotationController;
    }

    @Override
    public MoveController getMoveController() {
        return this.moveController;
    }

    @Override
    public LookController getLookController() {
        return this.lookController;
    }

    public boolean isDetectingPlayers() {
        return this.detectingPlayers;
    }

    @Override
    public boolean isRemoved() {
        return this.isRemoved;
    }

    @Override
    public boolean isWalking() {
        return this.isWalking;
    }

    @Override
    public boolean isStrafing() {
        return this.isStrafing;
    }

    @Override
    public boolean isJumping() {
        return this.isJumping;
    }

    @Override
    public boolean isFlying() {
        return this.isFlying;
    }

    @Override
    public float getYHeadRot() {
        return this.yHeadRot;
    }

    @Override
    public float getXHeadRot() {
        return this.xHeadRot;
    }

    @Override
    public float getYBodyRot() {
        return this.yBodyRot;
    }

    public void setDetectingPlayers(boolean detectingPlayers) {
        this.detectingPlayers = detectingPlayers;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public void setWalking(boolean isWalking) {
        this.isWalking = isWalking;
    }

    public void setStrafing(boolean isStrafing) {
        this.isStrafing = isStrafing;
    }

    public void setJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public void setFlying(boolean isFlying) {
        this.isFlying = isFlying;
    }

    public void setYHeadRot(float yHeadRot) {
        this.yHeadRot = yHeadRot;
    }

    public void setXHeadRot(float xHeadRot) {
        this.xHeadRot = xHeadRot;
    }

    public void setYBodyRot(float yBodyRot) {
        this.yBodyRot = yBodyRot;
    }
}

