/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.entity.data;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.CullType;
import com.ticxo.modelengine.api.entity.Hitbox;
import com.ticxo.modelengine.api.entity.data.AbstractEntityData;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.mount.MountPairManager;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.entity.wrapper.TrackedEntity;
import com.ticxo.modelengine.api.nms.impl.TempTrackedEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class BukkitEntityData
extends AbstractEntityData {
    protected final EntityHandler entityHandler = ModelEngineAPI.getEntityHandler();
    protected final Entity entity;
    protected final AtomicBoolean isEntityValid = new AtomicBoolean();
    protected final AtomicBoolean isDataValid = new AtomicBoolean();
    protected final AtomicBoolean isForcedAlive = new AtomicBoolean();
    protected final AtomicReference<Location> location = new AtomicReference();
    protected final AtomicReference<List<Entity>> passengers = new AtomicReference();
    protected final Set<Player> syncTracking = new HashSet<Player>();
    protected final Map<Player, CullType> asyncTracking = new HashMap<Player, CullType>();
    protected final Queue<Queue<Player>> startTrackingQueue = new ConcurrentLinkedQueue<Queue<Player>>();
    protected final Set<Player> startTracking = new HashSet<Player>();
    protected final Queue<Queue<Player>> stopTrackingQueue = new ConcurrentLinkedQueue<Queue<Player>>();
    protected final Set<Player> stopTracking = new HashSet<Player>();
    protected TrackedEntity tracked;
    protected int lastCulled;

    public BukkitEntityData(Entity entity) {
        this.entity = entity;
        this.tracked = this.entityHandler.wrapTrackedEntity(entity);
        this.syncUpdate();
        this.asyncUpdate();
        ModelEngineAPI.getAPI().getDataTracker().putEntityData(entity.getUniqueId(), this);
    }

    @Override
    public void asyncUpdate() {
        while (!this.startTrackingQueue.isEmpty() || !this.stopTrackingQueue.isEmpty()) {
            Player player;
            Queue<Player> playerQueue;
            if (!this.startTrackingQueue.isEmpty()) {
                playerQueue = this.startTrackingQueue.poll();
                while (!playerQueue.isEmpty()) {
                    player = playerQueue.poll();
                    this.startTracking.add(player);
                    this.stopTracking.remove(player);
                    this.asyncTracking.put(player, CullType.NO_CULL);
                }
            }
            if (this.stopTrackingQueue.isEmpty()) continue;
            playerQueue = this.stopTrackingQueue.poll();
            while (!playerQueue.isEmpty()) {
                player = playerQueue.poll();
                this.stopTracking.add(player);
                this.startTracking.remove(player);
                if (this.asyncTracking.get(player) == CullType.CULLED) continue;
                this.asyncTracking.remove(player);
            }
        }
        this.updateCulledPlayer();
    }

    @Override
    public void syncUpdate() {
        boolean valid = this.entity.isValid();
        this.isEntityValid.set(valid);
        this.isDataValid.set(valid || !this.entityHandler.isRemoved(this.entity));
        if (this.isForcedAlive()) {
            this.entityHandler.setDeathTick(this.entity, 0);
        } else if (!this.isEntityValid()) {
            this.entityHandler.setDeathTick(this.entity, 20);
        }
        this.location.set(this.entity.getLocation());
        this.passengers.set(this.entity.getPassengers());
        Set<Player> updatedTracking = this.getTracked().getTrackedPlayer(player -> this.asyncTracking.get(player) != CullType.CULLED);
        HashSet<Player> all = new HashSet<Player>(this.syncTracking);
        ConcurrentLinkedQueue<Player> startTrack = new ConcurrentLinkedQueue<Player>();
        ConcurrentLinkedQueue<Player> stopTrack = new ConcurrentLinkedQueue<Player>();
        all.addAll(updatedTracking);
        for (Player player2 : all) {
            if (!this.syncTracking.contains(player2)) {
                startTrack.add(player2);
                continue;
            }
            if (updatedTracking.contains(player2)) continue;
            stopTrack.add(player2);
        }
        this.syncTracking.clear();
        this.syncTracking.addAll(updatedTracking);
        this.startTrackingQueue.add(startTrack);
        this.stopTrackingQueue.add(stopTrack);
    }

    @Override
    public void cleanup() {
        this.startTracking.clear();
        this.stopTracking.clear();
    }

    @Override
    public void destroy() {
    }

    private void updateCulledPlayer() {
        if (--this.lastCulled > 0) {
            return;
        }
        this.lastCulled = this.cullInterval();
        MountPairManager pairManager = ModelEngineAPI.getMountPairManager();
        Location location = this.getLocation();
        for (Player player : this.asyncTracking.keySet()) {
            ActiveModel mounted = pairManager.getMountedPair(player.getUniqueId());
            if (mounted != null && mounted.getModeledEntity().getBase().getData() == this) {
                this.asyncTracking.put(player, CullType.NO_CULL);
                continue;
            }
            if (location.getWorld() != player.getWorld()) {
                this.asyncTracking.put(player, CullType.CULLED);
                continue;
            }
            Location eyeLoc = player.getEyeLocation();
            if (this.verticalCull()) {
                double distance = 0.0;
                Hitbox cullBox = this.getCullHitbox();
                distance = cullBox == null ? Math.abs(eyeLoc.getY() - location.getY()) : Math.max(eyeLoc.getY() - location.getY() - cullBox.getHeight(), location.getY() - eyeLoc.getY());
                if (distance > this.verticalCullDistance()) {
                    this.asyncTracking.put(player, this.verticalCullType());
                    continue;
                }
            }
            Vector delta = location.clone().subtract(eyeLoc).toVector();
            if (this.blockedCull() && delta.lengthSquared() > this.blockedCullIgnoreRadius() && this.entityHandler.shouldCull(player, this.entity, this.getCullHitbox())) {
                this.asyncTracking.put(player, this.blockedCullType());
                continue;
            }
            if (this.backCull()) {
                BoundingBox bb = this.entity.getBoundingBox();
                if (bb.contains(eyeLoc.toVector())) continue;
                if (delta.lengthSquared() > this.backCullIgnoreRadius() && eyeLoc.getDirection().dot(delta.normalize()) <= this.backCullAngle()) {
                    this.asyncTracking.put(player, this.backCullType());
                    continue;
                }
            }
            this.asyncTracking.put(player, CullType.NO_CULL);
        }
    }

    @Override
    public boolean isDataValid() {
        return this.isDataValid.get();
    }

    public boolean isEntityValid() {
        return this.isEntityValid.get();
    }

    public boolean isForcedAlive() {
        return this.isForcedAlive.get();
    }

    public void setForcedAlive(boolean flag) {
        this.isForcedAlive.set(flag);
    }

    @Override
    public Location getLocation() {
        return this.location.get().clone();
    }

    @Override
    public List<Entity> getPassengers() {
        return this.passengers.get();
    }

    @Override
    public Set<Player> getStartTracking() {
        return ImmutableSet.copyOf(this.startTracking);
    }

    @Override
    public Map<Player, CullType> getTracking() {
        return ImmutableMap.copyOf(this.asyncTracking);
    }

    @Override
    public Set<Player> getStopTracking() {
        return ImmutableSet.copyOf(this.stopTracking);
    }

    public TrackedEntity getTracked() {
        TrackedEntity trackedEntity = this.tracked;
        if (trackedEntity instanceof TempTrackedEntity) {
            TempTrackedEntity tempTracked = (TempTrackedEntity)trackedEntity;
            TrackedEntity newTracked = this.entityHandler.wrapTrackedEntity(this.entity);
            if (!(newTracked instanceof TempTrackedEntity)) {
                if (tempTracked.getBaseRange() != -1) {
                    newTracked.setBaseRange(tempTracked.getBaseRange());
                }
                newTracked.setPlayerPredicate(tempTracked.getPlayerPredicate());
                for (Player player : tempTracked.getForcePaired()) {
                    newTracked.addForcedPairing(player);
                }
                for (Player player : tempTracked.getForceHidden()) {
                    newTracked.addForcedHidden(player);
                }
                this.tracked = newTracked;
            }
        }
        return this.tracked;
    }
}

