/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.model.render;

import com.ticxo.modelengine.api.model.bone.render.renderer.RenderQueues;
import com.ticxo.modelengine.api.model.render.ModelRenderer;
import com.ticxo.modelengine.api.utils.data.tracker.CollectionDataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import java.util.UUID;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface DisplayRenderer
extends ModelRenderer,
RenderQueues<Bone> {
    public int getTick();

    public Pivot getPivot();

    public Hitbox getHitbox();

    public void pushFullUpdate(Player var1);

    public boolean pollFullUpdate(Player var1);

    public static interface Hitbox {
        public int getPivotId();

        public UUID getPivotUuid();

        public int getHitboxId();

        public UUID getHitboxUuid();

        public int getShadowId();

        public UUID getShadowUuid();

        public void clearDirty();

        public DataTracker<Vector3f> getPosition();

        public DataTracker<Float> getWidth();

        public DataTracker<Float> getHeight();

        public DataTracker<Float> getShadowRadius();

        public DataTracker<Boolean> getHitboxVisible();

        public DataTracker<Boolean> getShadowVisible();

        default public boolean isHitboxDirty() {
            return this.getWidth().isDirty() || this.getHeight().isDirty();
        }

        default public boolean isHitboxVisible() {
            return this.getHitboxVisible().get();
        }

        default public boolean isShadowVisible() {
            return this.getShadowVisible().get();
        }

        default public boolean isPivotVisible() {
            return this.isHitboxVisible() || this.isShadowVisible();
        }
    }

    public static interface Bone {
        public int getId();

        public UUID getUuid();

        default public boolean isDirty() {
            return this.isTransformDirty() || this.getModel().isDirty() || this.getDisplay().isDirty() || this.getVisibility().isDirty();
        }

        default public boolean isTransformDirty() {
            return this.getPosition().isDirty() || this.getLeftRotation().isDirty() || this.getScale().isDirty() || this.getRightRotation().isDirty();
        }

        default public void clearDirty() {
            this.getPosition().clearDirty();
            this.getLeftRotation().clearDirty();
            this.getScale().clearDirty();
            this.getRightRotation().clearDirty();
            this.getModel().clearDirty();
            this.getDisplay().clearDirty();
            this.getVisibility().clearDirty();
        }

        public DataTracker<Vector3f> getPosition();

        public DataTracker<Quaternionf> getLeftRotation();

        public DataTracker<Vector3f> getScale();

        public DataTracker<Quaternionf> getRightRotation();

        public DataTracker<ItemStack> getModel();

        public DataTracker<ItemDisplay.ItemDisplayTransform> getDisplay();

        public DataTracker<Boolean> getVisibility();
    }

    public static interface Pivot {
        public int getId();

        public UUID getUuid();

        public void clearDirty();

        public DataTracker<Vector3f> getPosition();

        public CollectionDataTracker<Integer> getPassengers();
    }
}

