/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.api.utils.ticker;

import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.api.utils.scheduling.PlatformScheduler;
import com.ticxo.modelengine.api.utils.scheduling.PlatformTask;
import com.ticxo.modelengine.api.utils.ticker.Task;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PseudoThread {
    private final String name;
    private final PlatformScheduler scheduler;
    private final JavaPlugin plugin;
    private final boolean isAsync;
    private final int delay;
    private final int period;
    private final boolean canWait;
    private final Queue<Task> taskQueue = new ConcurrentLinkedQueue<Task>();
    private final List<Task> tasks = new ArrayList<Task>();
    private PlatformTask tickTask;
    private boolean locked;
    private int skipped;

    public void start() {
        this.tickTask = this.isAsync ? this.scheduler.scheduleRepeatingAsync((Plugin)this.plugin, this::tick, this.delay, this.period) : this.scheduler.scheduleRepeating((Plugin)this.plugin, this::tick, this.delay, this.period);
    }

    public void end() {
        this.taskQueue.clear();
        this.tasks.clear();
        if (this.tickTask != null) {
            this.tickTask.cancel();
        }
    }

    public void queueTask(Task task) {
        this.taskQueue.add(task);
    }

    private void tick() {
        if (this.locked) {
            ++this.skipped;
            return;
        }
        this.locked = true;
        while (!this.taskQueue.isEmpty()) {
            this.tasks.add(this.taskQueue.poll());
        }
        this.tasks.removeIf(Task::tick);
        this.locked = false;
        if (this.skipped > 0) {
            if (!this.canWait) {
                TLogger.debug("The pseudo thread [" + this.name + "] has skipped " + this.skipped + (this.skipped == 1 ? " tick" : " ticks") + ". Is it overloaded?");
            }
            this.skipped = 0;
        }
    }

    public PseudoThread(String name, PlatformScheduler scheduler, JavaPlugin plugin, boolean isAsync, int delay, int period, boolean canWait) {
        this.name = name;
        this.scheduler = scheduler;
        this.plugin = plugin;
        this.isAsync = isAsync;
        this.delay = delay;
        this.period = period;
        this.canWait = canWait;
    }

    public String getName() {
        return this.name;
    }
}

