/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.generator.parser.modelengine.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.error.ErrorMissingBoneBehaviorData;
import com.ticxo.modelengine.api.error.ErrorUnknownBoneBehavior;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorRegistry;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.model.bone.type.PlayerLimb;
import com.ticxo.modelengine.core.generator.parser.blockbench.json.BlockbenchModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.entity.ItemDisplay;
import org.joml.Vector3f;

public class ModelEngineExtraData {
    protected final Map<UUID, BoneProperty> boneProperties = new HashMap<UUID, BoneProperty>();

    public Map<UUID, BoneProperty> getBoneProperties() {
        return this.boneProperties;
    }

    public static class CustomOption {
        protected final String id;
        protected final String jsonValue;
        protected final boolean enabled;

        public void populate(BlockbenchModel.Bone bone) {
            Object value;
            Class<?> dataType;
            JsonElement jsonData;
            String key;
            if (!this.enabled) {
                return;
            }
            BoneBehaviorRegistry registry = ModelEngineAPI.getAPI().getBoneBehaviorRegistry();
            BoneBehaviorType<?> type = registry.getById(this.id);
            if (type == null) {
                new ErrorUnknownBoneBehavior(this.id, bone.getName()).log();
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            Gson gson = registry.getGson();
            JsonObject jsonObject = (JsonObject)gson.fromJson(this.jsonValue, JsonObject.class);
            for (Map.Entry<String, Class<?>> entry : type.getRequiredArguments().entrySet()) {
                key = entry.getKey();
                if (!jsonObject.has(key)) {
                    new ErrorMissingBoneBehaviorData(bone.getName(), type, key).log();
                    return;
                }
                jsonData = jsonObject.get(key);
                dataType = entry.getValue();
                value = gson.fromJson(jsonData, dataType);
                map.put(key, value);
            }
            for (Map.Entry<String, Class<?>> entry : type.getOptionalArguments().entrySet()) {
                key = entry.getKey();
                if (!jsonObject.has(key)) continue;
                jsonData = jsonObject.get(key);
                dataType = entry.getValue();
                value = gson.fromJson(jsonData, dataType);
                map.put(key, value);
            }
            bone.getOptions().put(this.id, map);
        }

        public String getId() {
            return this.id;
        }

        public String getJsonValue() {
            return this.jsonValue;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public CustomOption(String id, String jsonValue, boolean enabled) {
            this.id = id;
            this.jsonValue = jsonValue;
            this.enabled = enabled;
        }
    }

    public static class BoneProperty {
        protected final Set<Behavior> behaviors = new LinkedHashSet<Behavior>();
        protected final List<CustomOption> customOptions = new ArrayList<CustomOption>();
        protected UUID dupeTarget;
        protected Vector3f boneScale;
        protected boolean renderByDefault = true;

        public Set<Behavior> getBehaviors() {
            return this.behaviors;
        }

        public List<CustomOption> getCustomOptions() {
            return this.customOptions;
        }

        public UUID getDupeTarget() {
            return this.dupeTarget;
        }

        public Vector3f getBoneScale() {
            return this.boneScale;
        }

        public boolean isRenderByDefault() {
            return this.renderByDefault;
        }
    }

    public static enum Behavior {
        HEAD(options -> options.put(BoneBehaviorTypes.HEAD.getId(), new HashMap())),
        SEGMENT(options -> options.put(BoneBehaviorTypes.SEGMENT.getId(), new HashMap())),
        GHOST(options -> options.put(BoneBehaviorTypes.GHOST.getId(), new HashMap())),
        LEASH(options -> options.put(BoneBehaviorTypes.LEASH.getId(), new HashMap())),
        NAMETAG(options -> options.put(BoneBehaviorTypes.NAMETAG.getId(), new HashMap())),
        ITEM_HEAD(options -> options.put(BoneBehaviorTypes.ITEM.getId(), new HashMap<String, Object>(){
            {
                this.put("display", ItemDisplay.ItemDisplayTransform.HEAD);
            }
        })),
        ITEM_RIGHT(options -> options.put(BoneBehaviorTypes.ITEM.getId(), new HashMap<String, Object>(){
            {
                this.put("display", ItemDisplay.ItemDisplayTransform.THIRDPERSON_RIGHTHAND);
            }
        })),
        ITEM_LEFT(options -> options.put(BoneBehaviorTypes.ITEM.getId(), new HashMap<String, Object>(){
            {
                this.put("display", ItemDisplay.ItemDisplayTransform.THIRDPERSON_LEFTHAND);
            }
        })),
        SUB_AABB(options -> options.put(BoneBehaviorTypes.SUB_HITBOX.getId(), new HashMap())),
        SUB_OBB(options -> options.put(BoneBehaviorTypes.SUB_HITBOX.getId(), new HashMap<String, Object>(){
            {
                this.put("obb", true);
            }
        })),
        DRIVER(options -> options.put(BoneBehaviorTypes.MOUNT.getId(), new HashMap<String, Object>(){
            {
                this.put("driver", true);
            }
        })),
        PASSENGER(options -> options.put(BoneBehaviorTypes.MOUNT.getId(), new HashMap<String, Object>(){
            {
                this.put("driver", false);
            }
        })),
        PLAYER_HEAD(options -> options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), new HashMap<String, Object>(){
            {
                this.put("limb", PlayerLimb.Limb.HEAD);
            }
        })),
        PLAYER_BODY(options -> options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), new HashMap<String, Object>(){
            {
                this.put("limb", PlayerLimb.Limb.BODY);
            }
        })),
        PLAYER_RIGHT_ARM(options -> options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), new HashMap<String, Object>(){
            {
                this.put("limb", PlayerLimb.Limb.RIGHT_ARM);
            }
        })),
        PLAYER_LEFT_ARM(options -> options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), new HashMap<String, Object>(){
            {
                this.put("limb", PlayerLimb.Limb.LEFT_ARM);
            }
        })),
        PLAYER_RIGHT_LEG(options -> options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), new HashMap<String, Object>(){
            {
                this.put("limb", PlayerLimb.Limb.RIGHT_LEG);
            }
        })),
        PLAYER_LEFT_LEG(options -> options.put(BoneBehaviorTypes.PLAYER_LIMB.getId(), new HashMap<String, Object>(){
            {
                this.put("limb", PlayerLimb.Limb.LEFT_LEG);
            }
        }));

        private final Consumer<Map<String, Map<String, Object>>> optionPopulate;

        public void populate(BlockbenchModel.Bone bone) {
            this.optionPopulate.accept(bone.getOptions());
        }

        private Behavior(Consumer<Map<String, Map<String, Object>>> optionPopulate) {
            this.optionPopulate = optionPopulate;
        }
    }
}

