/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model.bone.behavior;

import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.AbstractBoneBehavior;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorData;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehaviorType;
import com.ticxo.modelengine.api.model.bone.type.NameTag;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.bukkit.Location;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class NameTagImpl
extends AbstractBoneBehavior<NameTagImpl>
implements NameTag {
    private static final String EMPTY_STRING = "{\"text\":\"\"}";
    private final Vector3f location = new Vector3f();
    private String jsonString = "{\"text\":\"\"}";
    private Supplier<String> jsonStringSupplier;
    private boolean visible;

    public NameTagImpl(ModelBone bone, BoneBehaviorType<NameTagImpl> type, BoneBehaviorData data) {
        super(bone, type, data);
    }

    @Override
    public void onFinalize() {
        if (this.jsonStringSupplier != null) {
            this.setJsonString(this.jsonStringSupplier.get());
        }
        Location baseLocation = this.bone.getActiveModel().getModeledEntity().getBase().getLocation();
        this.bone.getGlobalPosition().rotateY((180.0f - this.bone.getYaw()) * ((float)Math.PI / 180), this.location).add((float)baseLocation.getX(), (float)baseLocation.getY(), (float)baseLocation.getZ());
    }

    @Override
    public void setString(String name) {
        this.setComponent((Component)Component.text((String)name));
    }

    @Override
    public void setComponent(Component component) {
        this.setJsonString((String)GsonComponentSerializer.gson().serialize(component));
    }

    @Override
    public String getJsonString() {
        return this.jsonString == null ? EMPTY_STRING : this.jsonString;
    }

    @Override
    public void setJsonString(String json) {
        this.jsonString = json == null ? EMPTY_STRING : json;
    }

    @Override
    public void setComponentSupplier(@Nullable Supplier<Component> component) {
        this.jsonStringSupplier = component == null ? null : () -> (String)GsonComponentSerializer.gson().serialize((Component)component.get());
    }

    @Override
    public Vector3f getLocation() {
        return this.location;
    }

    @Override
    public Supplier<String> getJsonStringSupplier() {
        return this.jsonStringSupplier;
    }

    @Override
    public void setJsonStringSupplier(Supplier<String> jsonStringSupplier) {
        this.jsonStringSupplier = jsonStringSupplier;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

