/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.model.bone.render;

import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.bone.BoneBehaviorTypes;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.behavior.BoneBehavior;
import com.ticxo.modelengine.api.model.bone.render.BehaviorRendererParser;
import com.ticxo.modelengine.api.model.bone.render.renderer.NameTagRenderer;
import com.ticxo.modelengine.api.model.bone.type.NameTag;
import com.ticxo.modelengine.api.utils.data.tracker.DataTracker;
import com.ticxo.modelengine.api.utils.data.tracker.UpdateDataTracker;
import com.ticxo.modelengine.core.model.bone.render.AbstractBehaviorRenderer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.joml.Vector3f;

public class NameTagRendererImpl
extends AbstractBehaviorRenderer
implements NameTagRenderer {
    private final BehaviorRendererParser<NameTagRenderer> parser;
    private final Map<String, NameTagRenderer.NameTag> spawnQueue = new HashMap<String, NameTagRenderer.NameTag>();
    private final Map<String, NameTagRenderer.NameTag> rendered = new HashMap<String, NameTagRenderer.NameTag>();
    private final Map<String, NameTagRenderer.NameTag> destroyQueue = new HashMap<String, NameTagRenderer.NameTag>();
    private boolean initialized;

    public NameTagRendererImpl(ActiveModel activeModel) {
        super(activeModel);
        this.parser = this.nmsHandler.getBehaviorRendererParser(this);
    }

    @Override
    public void initialize() {
        for (Map.Entry<String, ModelBone> boneEntry : this.activeModel.getBones().entrySet()) {
            String boneId = boneEntry.getKey();
            ModelBone modelBone = boneEntry.getValue();
            this.create(boneId, modelBone);
        }
        this.initialized = true;
    }

    private void create(String boneId, ModelBone modelBone) {
        Optional<? extends NameTag> maybeData = modelBone.getBoneBehavior(BoneBehaviorTypes.NAMETAG);
        if (maybeData.isEmpty()) {
            return;
        }
        BoneBehavior nameTagData = (BoneBehavior)((Object)maybeData.get());
        NameTagImpl nameTag = new NameTagImpl(this.nmsHandler.getEntityHandler().getNextEntityId(), UUID.randomUUID(), this.nmsHandler.getEntityHandler().getNextEntityId(), UUID.randomUUID());
        nameTag.position.set(((NameTag)((Object)nameTagData)).getLocation());
        nameTag.jsonString.set(((NameTag)((Object)nameTagData)).getJsonString());
        nameTag.visibility.set(((NameTag)((Object)nameTagData)).isVisible());
        this.spawnQueue.put(boneId, nameTag);
        this.destroyQueue.remove(boneId);
    }

    @Override
    public void readBoneData() {
        if (!this.initialized) {
            return;
        }
        this.destroyQueue.putAll(this.rendered);
        for (Map.Entry<String, ModelBone> boneEntry : this.activeModel.getBones().entrySet()) {
            String boneId = boneEntry.getKey();
            ModelBone modelBone = boneEntry.getValue();
            NameTagRenderer.NameTag renderer = this.rendered.get(boneId);
            if (renderer != null) {
                this.read(boneId, renderer, modelBone);
                continue;
            }
            this.create(boneId, modelBone);
        }
    }

    private void read(String boneId, NameTagRenderer.NameTag nameTag, ModelBone modelBone) {
        Optional<? extends NameTag> maybeData = modelBone.getBoneBehavior(BoneBehaviorTypes.NAMETAG);
        maybeData.ifPresent(nameTagData -> {
            nameTag.getPosition().set(((NameTag)((Object)nameTagData)).getLocation());
            nameTag.getJsonString().set(((NameTag)((Object)nameTagData)).getJsonString());
            nameTag.getVisibility().set(((NameTag)((Object)nameTagData)).isVisible());
            this.destroyQueue.remove(boneId);
        });
    }

    @Override
    public void sendToClient() {
        if (!this.initialized) {
            return;
        }
        this.destroyQueue.keySet().forEach(this.rendered::remove);
        this.parser.sendToClients(this);
        this.rendered.putAll(this.spawnQueue);
        this.spawnQueue.clear();
        this.destroyQueue.clear();
    }

    @Override
    public void destroy() {
        if (!this.initialized) {
            return;
        }
        this.parser.destroy(this);
    }

    @Override
    public Map<String, NameTagRenderer.NameTag> getSpawnQueue() {
        return this.spawnQueue;
    }

    @Override
    public Map<String, NameTagRenderer.NameTag> getRendered() {
        return this.rendered;
    }

    @Override
    public Map<String, NameTagRenderer.NameTag> getDestroyQueue() {
        return this.destroyQueue;
    }

    public static class NameTagImpl
    implements NameTagRenderer.NameTag {
        private final int pivotId;
        private final UUID pivotUuid;
        private final int tagId;
        private final UUID tagUuid;
        private final DataTracker<Vector3f> position = new UpdateDataTracker<Vector3f>(new Vector3f(), Vector3f::set);
        private final DataTracker<String> jsonString = new DataTracker<String>("{\"text\":\"\"}");
        private final DataTracker<Boolean> visibility = new DataTracker<Boolean>(true);

        public NameTagImpl(int pivotId, UUID pivotUuid, int tagId, UUID tagUuid) {
            this.pivotId = pivotId;
            this.pivotUuid = pivotUuid;
            this.tagId = tagId;
            this.tagUuid = tagUuid;
        }

        @Override
        public int getPivotId() {
            return this.pivotId;
        }

        @Override
        public UUID getPivotUuid() {
            return this.pivotUuid;
        }

        @Override
        public int getTagId() {
            return this.tagId;
        }

        @Override
        public UUID getTagUuid() {
            return this.tagUuid;
        }

        @Override
        public DataTracker<Vector3f> getPosition() {
            return this.position;
        }

        @Override
        public DataTracker<String> getJsonString() {
            return this.jsonString;
        }

        @Override
        public DataTracker<Boolean> getVisibility() {
            return this.visibility;
        }
    }
}

