/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.compatibility;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.impl.EmptyBodyRotationController;
import com.ticxo.modelengine.api.nms.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.impl.EmptyMoveController;
import com.ticxo.modelengine.core.ModelEngine;
import com.ticxo.modelengine.core.mythic.compatibility.ProjectileData;
import io.lumine.mythic.api.adapters.AbstractVector;
import io.lumine.mythic.core.skills.projectiles.Projectile;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;

public class ProjectileEntity
implements BaseEntity<Projectile.ProjectileTracker> {
    private final Projectile.ProjectileTracker original;
    private final ProjectileData data;
    private final int entityId;
    private final UUID uuid;
    private final BodyRotationController bodyRotationController = new EmptyBodyRotationController();
    private final MoveController moveController = new EmptyMoveController();
    private final LookController lookController = new EmptyLookController();
    private int renderRadius = 32;

    public ProjectileEntity(Projectile.ProjectileTracker original) {
        this.original = original;
        this.entityId = ModelEngineAPI.getEntityHandler().getNextEntityId();
        this.uuid = UUID.randomUUID();
        this.data = new ProjectileData(this);
        ModelEngine.CORE.getMythicCompatibility().getMythicSupport().getTrackers().put(original, this);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void setVisible(boolean flag) {
    }

    @Override
    public boolean isRemoved() {
        return !this.data.isDataValid();
    }

    @Override
    public boolean isAlive() {
        return this.data.isDataValid();
    }

    @Override
    public boolean isForcedAlive() {
        return false;
    }

    @Override
    public void setForcedAlive(boolean flag) {
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public double getMaxStepHeight() {
        return 0.0;
    }

    @Override
    public void setMaxStepHeight(double stepHeight) {
    }

    @Override
    public void setCollidableWith(Entity entity, boolean flag) {
    }

    @Override
    public boolean hurt(@Nullable HumanEntity player, Object nmsDamageCause, float damage) {
        return false;
    }

    @Override
    public EntityHandler.InteractionResult interact(HumanEntity player, EquipmentSlot slot) {
        return null;
    }

    @Override
    public float getYRot() {
        AbstractVector vel = this.original.getCurrentVelocity();
        if (vel == null) {
            return 0.0f;
        }
        return (float)Math.toDegrees(Math.atan2(-vel.getX(), vel.getZ()));
    }

    @Override
    public float getYHeadRot() {
        return this.getYRot();
    }

    @Override
    public float getXHeadRot() {
        AbstractVector vel = this.original.getCurrentVelocity();
        if (vel == null) {
            return 0.0f;
        }
        double hMag = Math.sqrt(vel.getX() * vel.getX() + vel.getZ() * vel.getZ());
        return (float)Math.toDegrees(-Math.atan2(vel.getY(), hMag));
    }

    @Override
    public float getYBodyRot() {
        return this.getYRot();
    }

    @Override
    public boolean isWalking() {
        return false;
    }

    @Override
    public boolean isStrafing() {
        return false;
    }

    @Override
    public boolean isJumping() {
        return false;
    }

    @Override
    public boolean isFlying() {
        return false;
    }

    public void removeSelf() {
        ModelEngine.CORE.getMythicCompatibility().getMythicSupport().getTrackers().remove(this.original, this);
    }

    @Override
    public Projectile.ProjectileTracker getOriginal() {
        return this.original;
    }

    @Override
    public ProjectileData getData() {
        return this.data;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public BodyRotationController getBodyRotationController() {
        return this.bodyRotationController;
    }

    @Override
    public MoveController getMoveController() {
        return this.moveController;
    }

    @Override
    public LookController getLookController() {
        return this.lookController;
    }

    @Override
    public int getRenderRadius() {
        return this.renderRadius;
    }

    @Override
    public void setRenderRadius(int renderRadius) {
        this.renderRadius = renderRadius;
    }
}

