/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.core.mythic.mechanics.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.core.mythic.MythicUtils;
import com.ticxo.modelengine.core.mythic.utils.MythicMechanic;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.ITargetedEntitySkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import java.util.Map;
import org.bukkit.Color;

@MythicMechanic(name="tint", aliases={"color"})
public class TintMechanic
implements ITargetedEntitySkill {
    private final PlaceholderString modelId;
    private final PlaceholderString partId;
    private final PlaceholderString color;
    private final boolean damageTint;
    private final boolean exactMatch;

    public TintMechanic(MythicLineConfig mlc) {
        this.modelId = mlc.getPlaceholderString(new String[]{"m", "mid", "model", "modelid"}, null, new String[0]);
        this.partId = mlc.getPlaceholderString(new String[]{"p", "pid", "part", "partid"}, "", new String[0]);
        this.damageTint = mlc.getBoolean(new String[]{"d", "dmg", "damage", "damagetint"}, false);
        this.color = mlc.getPlaceholderString(new String[]{"c", "color"}, this.damageTint ? "FF6666" : "FFFFFF", new String[0]);
        this.exactMatch = mlc.getBoolean(new String[]{"em", "exact", "match", "exactmatch"}, true);
    }

    public SkillResult castAtEntity(SkillMetadata meta, AbstractEntity target) {
        ModeledEntity model = ModelEngineAPI.getModeledEntity(target.getUniqueId());
        if (model == null) {
            return SkillResult.CONDITION_FAILED;
        }
        String colorString = MythicUtils.getOrNull(this.color, (PlaceholderMeta)meta, target);
        if (colorString.startsWith("#")) {
            colorString = colorString.substring(1);
        }
        Color color = Color.fromRGB((int)Integer.parseInt(colorString, 16));
        String partId = MythicUtils.getOrNullLowercase(this.partId, (PlaceholderMeta)meta, target);
        String modelId = MythicUtils.getOrNullLowercase(this.modelId, (PlaceholderMeta)meta, target);
        MythicUtils.executeOptModelId(model, modelId, activeModel -> this.color((ActiveModel)activeModel, partId, color));
        return SkillResult.SUCCESS;
    }

    private void color(ActiveModel activeModel, String partId, Color color) {
        if (partId.isBlank()) {
            if (this.damageTint) {
                activeModel.setDamageTint(color);
            } else {
                activeModel.setDefaultTint(color);
            }
            return;
        }
        if (this.exactMatch) {
            activeModel.getBone(partId).ifPresent(bone -> {
                if (this.damageTint) {
                    bone.setDamageTint(color);
                } else {
                    bone.setDefaultTint(color);
                }
            });
            return;
        }
        for (Map.Entry<String, ModelBone> entry : activeModel.getBones().entrySet()) {
            if (!entry.getKey().contains(partId)) continue;
            if (this.damageTint) {
                entry.getValue().setDamageTint(color);
                continue;
            }
            entry.getValue().setDefaultTint(color);
        }
    }
}

